/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.logic.ISkyColorProvider;
import com.xcompwiz.mystcraft.symbol.Color;
import com.xcompwiz.mystcraft.symbol.ColorGradient;
import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;

public class SymbolColorSkyNight
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        ColorGradient gradient = ModifierUtils.popGradient(controller, 1.0f, 1.0f, 1.0f);
        controller.registerInterface(new Colorizer(controller, gradient));
    }

    @Override
    public String identifier() {
        return "ColorSkyNight";
    }

    private class Colorizer
    implements ISkyColorProvider {
        ColorGradient gradient;
        private IAgeController controller;

        public Colorizer(IAgeController controller, ColorGradient gradient) {
            this.controller = controller;
            this.gradient = gradient;
        }

        @Override
        public Color getSkyColor(Entity entity, BiomeGenBase biome, float time, float celestial_angle) {
            float alpha = MathHelper.func_76134_b((float)(celestial_angle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
            if (alpha < 0.0f) {
                alpha = 0.0f;
            }
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            alpha = 1.0f - alpha;
            Color color = this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
            color = new Color(color.r * alpha, color.g * alpha, color.b * alpha);
            return color;
        }
    }
}

