/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.logic.IFogColorProvider;
import com.xcompwiz.mystcraft.symbol.Color;
import com.xcompwiz.mystcraft.symbol.ColorGradient;
import com.xcompwiz.mystcraft.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;

public class SymbolColorFog
extends SymbolBase {
    @Override
    public void registerLogic(IAgeController controller, long seed) {
        ColorGradient gradient = ModifierUtils.popGradient(controller, 0.7529412f, 0.8470588f, 1.0f);
        controller.registerInterface(new FogColorizer(controller, gradient));
    }

    @Override
    public String identifier() {
        return "ColorFog";
    }

    private static class FogColorizer
    implements IFogColorProvider {
        private static final Color black = new Color(1.0E-4f, 1.0E-4f, 1.0E-4f);
        ColorGradient gradient;
        private IAgeController controller;

        public FogColorizer(IAgeController controller, ColorGradient gradient) {
            this.controller = controller;
            this.gradient = gradient;
        }

        @Override
        public Color getFogColor(float f, float f1) {
            Color color = this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
            if (color.r == 0.0f && color.g == 0.0f && color.b == 0.0f) {
                color = black;
            }
            return color;
        }
    }
}

