/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.modifiers;

import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.symbol.Color;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.world.IAgeController;
import com.xcompwiz.util.CollectionUtils;
import java.util.ArrayList;

public class ModifierColor
extends SymbolBase {
    private float red;
    private float green;
    private float blue;
    private String name;

    public ModifierColor(float r, float g, float b, String name) {
        this.name = name;
        this.red = r;
        this.green = g;
        this.blue = b;
        this.setWords(new String[]{"Transform", "Image", "Weave", this.name});
        this.setRarity(0.98f);
    }

    @Override
    public ArrayList<GrammarGenerator.Rule> createRules() {
        return CollectionUtils.buildList(new GrammarGenerator.Rule("ColorBasic", CollectionUtils.buildList(this.identifier()), 1.0f));
    }

    @Override
    public void registerLogic(IAgeController controller, long seed) {
        Color color = controller.popModifier("color").asColor();
        color = color != null ? color.average(this.red, this.green, this.blue) : new Color(this.red, this.green, this.blue);
        controller.setModifier("color", color);
    }

    @Override
    public String identifier() {
        return "Mod" + this.name;
    }

    @Override
    public String displayName() {
        return this.name + " Color";
    }
}

