/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.world.logic.IWeatherController;
import com.xcompwiz.mystcraft.world.storage.IStorageObject;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class WeatherControllerToggleable
implements IWeatherController {
    private IStorageObject infoObj;
    private Random random = new Random();
    private int updateLCG = this.random.nextInt();
    protected double rainingStrength;
    protected double thunderingStrength;
    protected int reset_cooldown = 12000;
    protected Float fixedtemp = null;
    protected Boolean snowEnabled = null;
    protected Boolean rainEnabled = null;

    @Override
    public void setDataObject(IStorageObject infoObj) {
        this.infoObj = infoObj;
        this.rainingStrength = 0.0;
        this.thunderingStrength = 0.0;
        if (infoObj.getBoolean("disabled")) {
            this.disable();
        } else {
            this.enable();
        }
    }

    @Override
    public void updateRaining() {
        int reset_counter = this.infoObj.getInteger("reset_counter");
        this.infoObj.setInteger("reset_counter", --reset_counter);
        if (reset_counter == 0) {
            this.enable();
        }
    }

    @Override
    public void tick(World worldObj, Chunk chunk) {
        if (worldObj.func_72896_J() && worldObj.func_72911_I() && worldObj.field_73012_v.nextInt(100000) == 0) {
            int xBase = chunk.field_76635_g * 16;
            int zBase = chunk.field_76647_h * 16;
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int coords = this.updateLCG >> 2;
            int x = xBase + (coords & 0xF);
            int z = zBase + (coords >> 8 & 0xF);
            int y = worldObj.func_72874_g(x, z);
            if (worldObj.func_72951_B(x, y, z)) {
                worldObj.func_72942_c((Entity)new EntityLightningBolt(worldObj, (double)x, (double)y, (double)z));
            }
        }
    }

    @Override
    public void reset() {
        this.enable();
    }

    @Override
    public void togglePrecipitation() {
        if (this.isDisabled()) {
            this.enable();
        } else {
            this.disable();
        }
    }

    protected final boolean isDisabled() {
        return this.infoObj.getBoolean("disabled");
    }

    @Override
    public float getRainingStrength() {
        return (float)this.rainingStrength;
    }

    @Override
    public float getStormStrength() {
        return (float)this.thunderingStrength;
    }

    @Override
    public float getTemperature(float current, int biomeId) {
        if (this.fixedtemp != null) {
            return this.fixedtemp.floatValue();
        }
        return current;
    }

    @Override
    public float getRainfall(float current, int biomeId) {
        return current;
    }

    private final void enable() {
        this.infoObj.setInteger("reset_counter", 0);
        this.infoObj.setBoolean("disabled", false);
        this.onEnable();
    }

    private final void disable() {
        this.infoObj.setInteger("reset_counter", this.reset_cooldown);
        this.infoObj.setBoolean("disabled", true);
        this.fixedtemp = null;
        this.snowEnabled = null;
        this.rainEnabled = null;
        this.onDisable();
    }

    @Override
    public boolean getEnableSnow(boolean current, int biomeId) {
        if (this.snowEnabled != null) {
            return this.snowEnabled;
        }
        return current;
    }

    @Override
    public boolean getEnableRain(boolean current, int biomeId) {
        if (this.rainEnabled != null) {
            return this.rainEnabled;
        }
        return current;
    }

    protected abstract void onEnable();

    protected abstract void onDisable();
}

