/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.page.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class SymbolRemappings {
    private static HashMap<String, List<String>> mappings = new HashMap();

    public static void initialize() {
        SymbolRemappings.fogColorRemappings();
        SymbolRemappings.cloudColorRemappings();
        SymbolRemappings.skyColorRemappings();
        SymbolRemappings.horizonColorRemappings();
        SymbolRemappings.addSymbolRemapping("LavaLakes", "ModMat_tile.lava", "LakesDeep");
        SymbolRemappings.addSymbolRemapping("Lakes", "ModMat_tile.water", "LakesSurface");
        SymbolRemappings.addSymbolRemapping("CryFormCry", "ModMat_tile.myst.crystal", "CryForm");
        SymbolRemappings.addSymbolRemapping("CryFormGlow", "ModMat_tile.myst.lightgem", "CryForm");
        SymbolRemappings.addSymbolRemapping("CryFormQuartz", "ModMat_tile.myst.netherquartz", "CryForm");
        SymbolRemappings.addSymbolRemapping("Standard Terrain", "TerrainNormal");
        SymbolRemappings.addSymbolRemapping("Star Fissure", "StarFissure");
        SymbolRemappings.addSymbolRemapping("Rain", "WeatherRain");
        SymbolRemappings.addSymbolRemapping("Snow", "WeatherSnow");
        SymbolRemappings.addSymbolRemapping("Huge Trees", "HugeTrees");
        SymbolRemappings.addSymbolRemapping("NormalStars", "StarsNormal");
        SymbolRemappings.addSymbolRemapping("Single Biome", "BioConSingle");
        SymbolRemappings.addSymbolRemapping("Checkerboard Biomes", "BioConTiled");
        SymbolRemappings.addSymbolRemapping("BiomeControllerNative", "BioConNative");
        SymbolRemappings.addSymbolRemapping("Lava Lakes", "LavaLakes");
        SymbolRemappings.addSymbolRemapping("WeatherSun", "WeatherOff");
        SymbolRemappings.addSymbolRemapping("Standard Lighting", "LightingNormal");
        SymbolRemappings.addSymbolRemapping("Storm", "WeatherStorm");
        SymbolRemappings.addSymbolRemapping("Fog", "ColorFog");
        SymbolRemappings.addSymbolRemapping("ModFluid_tile.lava", "ModMat_tile.lava");
        SymbolRemappings.addSymbolRemapping("ModFluid_tile.water", "ModMat_tile.water");
        SymbolRemappings.addSymbolRemapping("ModFluidtile.water", "ModMat_tile.water");
        SymbolRemappings.addSymbolRemapping("ModFluidtile.lava", "ModMat_tile.lava");
        SymbolRemappings.addSymbolRemapping("ModLavaSea", "ModMat_tile.lava");
        SymbolRemappings.addSymbolRemapping("ModNetherTerrain", "ModMat_tile.hellrock");
        SymbolRemappings.addSymbolRemapping("ModMattile.hellrock", "ModMat_tile.hellrock");
        SymbolRemappings.addSymbolRemapping("ModMattile.whiteStone", "ModMat_tile.whiteStone");
        SymbolRemappings.addSymbolRemapping("ModMattile.oreDiamond", "ModMat_tile.oreDiamond");
        SymbolRemappings.addSymbolRemapping("TendrilsIce", "ModMat_tile.ice", "Tendrils");
        SymbolRemappings.addSymbolRemapping("WoodCaves", "Tendrils");
        SymbolRemappings.addSymbolRemapping("SkyDropDark", "StarsDark");
        SymbolRemappings.addSymbolRemapping("FTime", "ModHalf", "SunNormal", "ModHalf", "MoonNormal");
        SymbolRemappings.addSymbolRemapping("STime", "ModDouble", "SunNormal", "ModDouble", "MoonNormal");
        SymbolRemappings.addSymbolRemapping("NTime", "ModFull", "SunNormal", "ModFull", "MoonNormal");
        SymbolRemappings.addSymbolRemapping("Dusk", "ModZero", "ModSetting", "SunNormal", "ModZero", "MoonNormal");
        SymbolRemappings.addSymbolRemapping("Night", "SunDark", "ModZero", "MoonNormal");
        SymbolRemappings.addSymbolRemapping("Day", "MoonDark", "ModZero", "ModNoon", "SunNormal");
        SymbolRemappings.addSymbolRemapping("Heavy Resources", "DenseOres");
        SymbolRemappings.addSymbolRemapping("SunsetNormal", "SunsetRed");
        SymbolRemappings.addSymbolRemapping("CloudNormal", "CloudWhite");
        SymbolRemappings.addSymbolRemapping("Normal Sunset Colors", "SunsetRed");
        SymbolRemappings.addSymbolRemapping("NativeBiomeController", "BioConLarge");
        SymbolRemappings.addSymbolRemapping("Flat Sea", "Flat");
        SymbolRemappings.addSymbolRemapping("Sky Islands", "Skylands");
        SymbolRemappings.addSymbolRemapping("Tree Age", "Huge Trees", "Flat", "Swampland", "BioConSingle");
        SymbolRemappings.addSymbolRemapping("DefaultBiome", "BioConSingle");
        SymbolRemappings.addSymbolRemapping("DefaultLighting", "Standard Lighting");
        SymbolRemappings.addSymbolRemapping("DefaultSunrise", "Normal Sunset Colors");
        SymbolRemappings.addSymbolRemapping("DefaultTerrain", "Standard Terrain");
    }

    private static void addChromaticGradients(List<String> mapping) {
        mapping.add("ModBlack");
        mapping.add("ModRed");
        mapping.add("ModRed");
        mapping.add("ModGradient");
        mapping.add("ModBlack");
        mapping.add("ModGreen");
        mapping.add("ModGreen");
        mapping.add("ModGradient");
        mapping.add("ModBlack");
        mapping.add("ModBlue");
        mapping.add("ModBlue");
        mapping.add("ModGradient");
    }

    private static void fogColorRemappings() {
        ArrayList<String> mapping = null;
        mapping = new ArrayList<String>();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogWhite", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorFog");
        SymbolRemappings.addSymbolRemapping("FogNormal", mapping);
    }

    private static void cloudColorRemappings() {
        ArrayList<String> mapping = null;
        mapping = new ArrayList<String>();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemapping("CloudChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemapping("CloudRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemapping("CloudGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemapping("CloudBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemapping("CloudBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorCloud");
        SymbolRemappings.addSymbolRemapping("CloudWhite", "ModWhite", "ColorCloud");
    }

    private static void skyColorRemappings() {
        ArrayList<String> mapping = null;
        mapping = new ArrayList<String>();
        mapping.add("ModGradient");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("ModGradient_HERE", mapping);
        mapping = new ArrayList();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyWhite", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorSky");
        SymbolRemappings.addSymbolRemapping("SkyNormal", mapping);
    }

    private static void horizonColorRemappings() {
        ArrayList<String> mapping = null;
        mapping = new ArrayList<String>();
        SymbolRemappings.addChromaticGradients(mapping);
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemapping("SunsetChromatic", mapping);
        mapping = new ArrayList();
        mapping.add("ModRed");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemapping("SunsetRed", mapping);
        mapping = new ArrayList();
        mapping.add("ModGreen");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemapping("SunsetGreen", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlue");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemapping("SunsetBlue", mapping);
        mapping = new ArrayList();
        mapping.add("ModBlack");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemapping("SunsetBlack", mapping);
        mapping = new ArrayList();
        mapping.add("ModWhite");
        mapping.add("ColorHorizon");
        SymbolRemappings.addSymbolRemapping("SunsetWhite", mapping);
    }

    public static boolean hasRemapping(String symbol2) {
        return mappings.get(symbol2) != null;
    }

    public static List<String> remap(String symbol2) {
        List<String> symbols = mappings.get(symbol2);
        if (symbols == null) {
            symbols = new ArrayList<String>();
            symbols.add(symbol2);
        }
        return symbols;
    }

    public static List<ItemStack> remap(ItemStack page) {
        String symbol2 = Page.getSymbol(page);
        List<String> symbols = mappings.get(symbol2);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (symbols != null) {
            for (String mapping : symbols) {
                result.add(Page.createSymbolPage(mapping));
            }
            if (symbols.size() > 0) {
                Page.setSymbol(page, Page.getSymbol((ItemStack)result.get(0)));
                result.set(0, page.func_77946_l());
            }
        } else {
            result.add(page);
        }
        return result;
    }

    private static void addSymbolRemapping(String id, List<String> mapping) {
        mappings.put(id, mapping);
    }

    public static void addSymbolRemapping(String id, String ... newids) {
        ArrayList<String> mapping = new ArrayList<String>();
        for (String newid : newids) {
            mapping.add(newid);
        }
        mappings.put(id, mapping);
    }
}

