/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.symbol.Color;
import java.util.ArrayList;
import java.util.List;

public final class ColorGradient {
    private List<Color> colors = new ArrayList<Color>();
    private List<Float> intervals = new ArrayList<Float>();
    private float length = 0.0f;

    public int getColorCount() {
        return this.colors.size();
    }

    public float getLength() {
        return this.length;
    }

    public void appendGradient(ColorGradient other) {
        for (int i = 0; i < other.colors.size(); ++i) {
            this.pushColor(other.colors.get(i), other.intervals.get(i));
        }
    }

    public void pushColor(Color color) {
        this.pushColor(color, null);
    }

    public void pushColor(Color color, Float interval) {
        if (color == null) {
            return;
        }
        if (interval == null || interval.floatValue() <= 0.0f) {
            interval = Float.valueOf(1.0f);
        }
        if (interval.floatValue() < 0.0f) {
            interval = Float.valueOf(0.0f);
        }
        this.colors.add(color);
        this.intervals.add(Float.valueOf(interval.floatValue()));
        this.length += interval.floatValue();
    }

    public Color getColor(float value) {
        if (this.colors.size() == 0) {
            throw new RuntimeException("Whoops, empty gradient!");
        }
        if (this.colors.size() == 1) {
            return this.colors.get(0);
        }
        if (this.length <= 0.0f) {
            return this.colors.get(0);
        }
        value %= this.length;
        int colorcounter = 0;
        while (value >= this.intervals.get(colorcounter).floatValue()) {
            value -= this.intervals.get(colorcounter).floatValue();
            ++colorcounter;
            colorcounter %= this.colors.size();
        }
        int secondcolor = (colorcounter + 1) % this.colors.size();
        Color color1 = this.colors.get(colorcounter);
        Color color2 = this.colors.get(secondcolor);
        float interp = value / this.intervals.get(colorcounter).floatValue();
        Color colorout = new Color(this.interpolate(interp, color1.r, color2.r), this.interpolate(interp, color1.g, color2.g), this.interpolate(interp, color1.b, color2.b));
        return colorout;
    }

    private float interpolate(float interp, float val1, float val2) {
        return val2 * interp + val1 * (1.0f - interp);
    }
}

