/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network;

import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.MPacket;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;

public class MystcraftPacketHandler {
    public static final String CHANNEL = "mystcraft";
    public static FMLEventChannel bus;
    private static HashMap<Byte, MPacket> packethandlers;

    public static void registerPacketHandler(MPacket mPacket) {
        if (packethandlers.get(mPacket.getPacketType()) != null) {
            throw new RuntimeException("Multiple id registrations for packet type on Mystcraft channel");
        }
        packethandlers.put(mPacket.getPacketType(), mPacket);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket pkt = event.packet;
        this.onPacketData(event.manager, pkt, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket pkt = event.packet;
        this.onPacketData(event.manager, pkt, (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    public void onPacketData(NetworkManager manager, FMLProxyPacket packet, EntityPlayer player) {
        try {
            if (packet == null || packet.payload() == null) {
                throw new RuntimeException("Empty packet sent to Mystcraft channel");
            }
            ByteBuf data = packet.payload();
            byte type = data.readByte();
            try {
                MPacket handler = packethandlers.get(type);
                if (handler == null) {
                    throw new RuntimeException("Unrecognized packet sent to Mystcraft channel");
                }
                handler.handle(data, player);
            }
            catch (Exception e) {
                LoggerUtils.warn("PacketHandler: Failed to handle packet type " + type, new Object[0]);
                LoggerUtils.warn(e.toString(), new Object[0]);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            LoggerUtils.warn("PacketHandler: Failed to read packet", new Object[0]);
            LoggerUtils.warn(e.toString(), new Object[0]);
            e.printStackTrace();
        }
    }

    static {
        packethandlers = new HashMap();
    }
}

