/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.inventory.InventoryNotebook;
import com.xcompwiz.mystcraft.item.IItemFactory;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ItemFactory
implements IItemFactory {
    @Override
    public ItemStack buildPage() {
        return Page.createPage();
    }

    @Override
    public ItemStack buildSymbolPage(String identifier) {
        return Page.createSymbolPage(identifier);
    }

    @Override
    public ItemStack buildLinkPage(String ... properties) {
        ItemStack page = Page.createPage();
        Page.makeLinkPanel(page);
        for (String property : properties) {
            Page.addLinkProperty(page, property);
        }
        return page;
    }

    @Override
    public ItemStack buildNotebook(String name, String ... tokens) {
        HashSet<GrammarGenerator.Rule> rules = new HashSet<GrammarGenerator.Rule>();
        for (String token : tokens) {
            List<GrammarGenerator.Rule> tokenrules;
            if (token == null || (tokenrules = GrammarGenerator.getAllRules(token)) == null) continue;
            rules.addAll(tokenrules);
        }
        HashSet<IAgeSymbol> symbolsset = new HashSet<IAgeSymbol>();
        for (GrammarGenerator.Rule rule : rules) {
            for (String token : rule.getValues()) {
                IAgeSymbol symbol2;
                if (!SymbolManager.hasBinding(token) || (symbol2 = SymbolManager.getAgeSymbol(token)) == null) continue;
                symbolsset.add(symbol2);
            }
        }
        ArrayList<IAgeSymbol> symbols = new ArrayList<IAgeSymbol>();
        symbols.addAll(symbolsset);
        Collections.sort(symbols, SortingUtils.ComparatorSymbolAlphabetical.instance);
        ItemStack notebook = new ItemStack(ModItems.notebook, 1, 0);
        InventoryNotebook.setName(notebook, name);
        for (IAgeSymbol symbol3 : symbols) {
            InventoryNotebook.addItem(notebook, Page.createSymbolPage(symbol3.identifier()));
        }
        return notebook;
    }

    @Override
    public ItemStack buildNotebook(String name, ItemStack ... pages) {
        ItemStack notebook = new ItemStack(ModItems.notebook, 1, 0);
        InventoryNotebook.setName(notebook, name);
        for (ItemStack page : pages) {
            if (page == null || !(page.func_77973_b() instanceof ItemPage)) continue;
            InventoryNotebook.addItem(notebook, page.func_77946_l());
        }
        return notebook;
    }
}

