/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.IBookContainer;
import com.xcompwiz.mystcraft.inventory.InventoryBook;
import com.xcompwiz.mystcraft.inventory.SlotCollection;
import com.xcompwiz.mystcraft.inventory.SlotFiltered;
import com.xcompwiz.mystcraft.inventory.TargetInventory;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.linking.LinkListenerManager;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import com.xcompwiz.mystcraft.network.MPacketAgeData;
import com.xcompwiz.mystcraft.network.MPacketGuiMessage;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookDisplay;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.DimensionManager;

public class ContainerBook
extends ContainerBase
implements IGuiMessageHandler,
IBookContainer {
    private IInventory inventory;
    private InventoryPlayer inventoryplayer;
    private Integer slot;
    private ItemStack currentpage = null;
    private int pagecount = 0;
    private int currentpageIndex = 0;
    private ILinkInfo cached_linkinfo;
    private Boolean cached_permitted;

    public ContainerBook(InventoryPlayer inventoryplayer, IInventory inventory) {
        this.inventory = inventory;
        this.inventoryplayer = inventoryplayer;
        this.updateSlots();
    }

    public ContainerBook(InventoryPlayer inventoryplayer, int slot) {
        this.slot = slot;
        this.inventoryplayer = inventoryplayer;
        this.updateSlots();
    }

    @Override
    public ItemStack getBook() {
        ItemStack itemstack;
        if (this.inventory != null) {
            ItemStack itemstack2 = this.inventory.func_70301_a(0);
            if (itemstack2 != null && itemstack2.func_77973_b() instanceof ItemLinking) {
                return itemstack2;
            }
        } else if (this.slot != null && (itemstack = this.inventoryplayer.func_70301_a(this.slot.intValue())) != null && itemstack.func_77973_b() instanceof ItemLinking) {
            return itemstack;
        }
        return null;
    }

    @Override
    public void setCurrentPageIndex(int index) {
        List<ItemStack> pagelist;
        this.currentpage = null;
        this.currentpageIndex = 0;
        if (index < 0) {
            index = 0;
        }
        if ((pagelist = this.getPageList()) != null && index >= pagelist.size()) {
            index = pagelist.size();
        }
        if (pagelist != null && index < pagelist.size()) {
            this.pagecount = pagelist.size();
            this.currentpage = pagelist.get(index);
        }
        this.currentpageIndex = index;
    }

    @Override
    public ItemStack getCurrentPage() {
        if (this.currentpage == null) {
            this.setCurrentPageIndex(this.currentpageIndex);
        }
        return this.currentpage;
    }

    @Override
    public int getCurrentPageIndex() {
        return this.currentpageIndex;
    }

    private List<ItemStack> getPageList() {
        ItemStack book = this.getBook();
        if (book == null) {
            return null;
        }
        if (book.func_77973_b() instanceof ItemLinking) {
            return ((ItemLinking)book.func_77973_b()).getPageList(this.inventoryplayer.field_70458_d, book);
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pagecount;
    }

    @Override
    public boolean isTargetWorldVisited() {
        ItemStack book = this.getBook();
        if (book == null) {
            return false;
        }
        if (book.field_77990_d == null) {
            return false;
        }
        if (book.func_77973_b() instanceof ItemLinking) {
            int dim = LinkOptions.getDimensionUID(book.field_77990_d);
            if (DimensionManager.getProviderType((int)dim) == Mystcraft.providerId) {
                AgeData agedata = AgeData.getAge(dim, this.inventoryplayer.field_70458_d.field_70170_p.field_72995_K);
                if (agedata == null) {
                    return false;
                }
                return agedata.isVisited();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBookSlot() {
        return this.field_75151_b.size() > 0;
    }

    public int getInventorySize() {
        if (this.inventory == null) {
            return 0;
        }
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_75144_a(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        if (par1 >= this.field_75151_b.size()) {
            return null;
        }
        return super.func_75144_a(par1, par2, par3, par4EntityPlayer);
    }

    public void updateSlots() {
        if (this.inventory != null) {
            ItemStack book = this.getBook();
            if (this.currentpageIndex > 0) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
            } else if (book != null && this.field_75151_b.size() != 1) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
                this.func_75146_a(new SlotFiltered(this.inventory, 0, 41, 21));
            } else if (book == null && this.inventory.func_70302_i_() == 1 && this.field_75151_b.size() != 37) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
                this.addInventorySlots();
                this.func_75146_a(new SlotFiltered(this.inventory, 0, 80, 35));
            } else if (book == null && this.inventory.func_70302_i_() == 0 && this.field_75151_b.size() != 36) {
                this.field_75151_b.clear();
                this.field_75153_a.clear();
                this.addInventorySlots();
            }
        }
    }

    private void addInventorySlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.inventoryplayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryplayer, i, 8 + i * 18, 142));
        }
    }

    public void func_75142_b() {
        ArrayList<Object> packets = new ArrayList<Object>();
        for (int slotId = 0; slotId < this.field_75151_b.size(); ++slotId) {
            ItemStack actual = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            ItemStack stored = (ItemStack)this.field_75153_a.get(slotId);
            if (ItemStack.func_77989_b((ItemStack)stored, (ItemStack)actual)) continue;
            if (slotId == 0) {
                this.cached_linkinfo = null;
                this.cached_permitted = null;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("SetCurrentPage", this.currentpageIndex);
                packets.add(MPacketGuiMessage.createPacket(this.field_75152_c, nbttagcompound));
            }
            if (actual != null && actual.field_77990_d != null && actual.func_77973_b() == ModItems.agebook && ItemAgebook.getAgeData(this.inventoryplayer.field_70458_d.field_70170_p, actual) != null) {
                packets.add(MPacketAgeData.getDataPacket(LinkOptions.getDimensionUID(actual.field_77990_d)));
            }
            stored = actual == null ? null : actual.func_77946_l();
            this.field_75153_a.set(slotId, stored);
            for (int var4 = 0; var4 < this.field_75149_d.size(); ++var4) {
                ((ICrafting)this.field_75149_d.get(var4)).func_71111_a((Container)this, slotId, stored);
            }
        }
        if (this.cached_permitted == null) {
            this.cached_permitted = this.checkLinkPermitted();
            if (this.cached_permitted != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74757_a("LinkPermitted", this.cached_permitted.booleanValue());
                packets.add(MPacketGuiMessage.createPacket(this.field_75152_c, nbttagcompound));
            }
        }
        if (packets.size() > 0) {
            for (int var4 = 0; var4 < this.field_75149_d.size(); ++var4) {
                ICrafting crafter = (ICrafting)this.field_75149_d.get(var4);
                if (!(crafter instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)crafter;
                for (Packet packet : packets) {
                    player.field_71135_a.func_147359_a(packet);
                }
            }
        }
    }

    public void func_75137_b(int i, int j) {
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        this.updateSlots();
        if (this.inventory == null) {
            return this.getBook() != null;
        }
        return this.inventory.func_70300_a(entityplayer);
    }

    public Slot func_75147_a(IInventory par1IInventory, int par2) {
        for (int var3 = 0; var3 < this.field_75151_b.size(); ++var3) {
            Slot var4 = (Slot)this.field_75151_b.get(var3);
            if (!var4.func_75217_a(par1IInventory, par2)) continue;
            return var4;
        }
        return new Slot((IInventory)this.inventoryplayer, this.inventoryplayer.field_70461_c, 0, 0);
    }

    public Slot func_75139_a(int par1) {
        if (par1 >= this.field_75151_b.size()) {
            par1 = 0;
        }
        if (par1 < this.field_75151_b.size()) {
            return (Slot)this.field_75151_b.get(par1);
        }
        return new Slot((IInventory)this.inventoryplayer, this.inventoryplayer.field_70461_c, 0, 0);
    }

    @Override
    public void processMessage(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("LinkPermitted")) {
            this.cached_permitted = data.func_74767_n("LinkPermitted");
        }
        if (data.func_74764_b("SetCurrentPage")) {
            this.setCurrentPageIndex(data.func_74762_e("SetCurrentPage"));
        }
        if (data.func_74764_b("Link")) {
            ItemStack itemstack;
            if (this.inventory != null) {
                if (this.inventory instanceof TileEntityBookDisplay) {
                    ((TileEntityBookDisplay)this.inventory).link((Entity)player);
                }
                if (this.inventory instanceof InventoryBook) {
                    ((InventoryBook)this.inventory).linkEntity((Entity)player);
                }
            } else if (this.slot != null && (itemstack = this.inventoryplayer.func_70301_a(this.slot.intValue())).func_77973_b() instanceof ItemLinking) {
                ((ItemLinking)itemstack.func_77973_b()).activate(itemstack, player.field_70170_p, player);
            }
        }
    }

    @Override
    public ILinkInfo getLinkInfo() {
        ItemStack book = this.getBook();
        if (book == null || !(book.func_77973_b() instanceof ItemLinking)) {
            return null;
        }
        if (this.cached_linkinfo == null) {
            this.cached_linkinfo = ((ItemLinking)book.func_77973_b()).getLinkInfo(book);
        }
        return this.cached_linkinfo;
    }

    @Override
    public boolean isLinkPermitted() {
        ILinkInfo linkinfo = this.getLinkInfo();
        if (linkinfo == null) {
            this.cached_permitted = null;
        }
        if (this.cached_permitted == null) {
            return false;
        }
        return this.cached_permitted;
    }

    private boolean checkLinkPermitted() {
        ILinkInfo linkinfo = this.getLinkInfo();
        if (linkinfo == null) {
            return false;
        }
        return LinkListenerManager.isLinkPermitted(this.inventoryplayer.field_70458_d.field_70170_p, (Entity)this.inventoryplayer.field_70458_d, linkinfo);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack clone = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack original = slot.func_75211_c();
            clone = original.func_77946_l();
            ArrayList<SlotCollection> collections = new ArrayList<SlotCollection>();
            SlotCollection internal = null;
            SlotCollection maininv = null;
            SlotCollection hotbar = null;
            ItemStack book = this.getBook();
            if (book != null || this.inventory != null && this.inventory.func_70302_i_() > 0) {
                internal = new SlotCollection(this, this.field_75151_b.size() - 1, this.field_75151_b.size());
                internal.pushTargetFront(new TargetInventory(this.inventoryplayer));
                collections.add(internal);
            }
            if (book == null) {
                maininv = new SlotCollection(this, 0, 27);
                hotbar = new SlotCollection(this, 27, 36);
                maininv.pushTargetFront(hotbar);
                hotbar.pushTargetFront(maininv);
                if (internal != null) {
                    internal.pushTargetFront(maininv);
                    internal.pushTargetFront(hotbar);
                    maininv.pushTargetFront(internal);
                    hotbar.pushTargetFront(internal);
                }
                collections.add(maininv);
                collections.add(hotbar);
            }
            for (SlotCollection collection : collections) {
                if (!collection.contains(i)) continue;
                collection.onShiftClick(original);
                break;
            }
            if (original.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (original.field_77994_a != clone.field_77994_a) {
                slot.func_82870_a(player, original);
            } else {
                return null;
            }
        }
        return clone;
    }

    @Override
    public String getBookTitle() {
        ItemStack book = this.getBook();
        if (book == null || !(book.func_77973_b() instanceof ItemLinking)) {
            return "";
        }
        return ((ItemLinking)book.func_77973_b()).getTitle(book);
    }

    @Override
    public Collection<String> getBookAuthors() {
        ItemStack book = this.getBook();
        if (book == null || !(book.func_77973_b() instanceof ItemLinking)) {
            return Collections.EMPTY_SET;
        }
        return ((ItemLinking)book.func_77973_b()).getAuthors(book);
    }
}

