/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.providers;

import com.google.common.collect.ObjectArrays;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.instability.IInstabilityController;
import com.xcompwiz.mystcraft.instability.IInstabilityProvider;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.lang.reflect.Constructor;

public class InstabilityProvider
implements IInstabilityProvider {
    private Class<? extends IEnvironmentalEffect> effectclass;
    private Object[] itemCtorArgs;
    private boolean uselevel;
    private Constructor<? extends IEnvironmentalEffect> itemCtor;

    public InstabilityProvider(boolean uselevel, Class<? extends IEnvironmentalEffect> effectclass, Object ... itemCtorArgs) {
        this.effectclass = effectclass;
        this.itemCtorArgs = itemCtorArgs;
        this.uselevel = uselevel;
        Class[] ctorArgClasses = new Class[itemCtorArgs.length + (this.uselevel ? 1 : 0)];
        if (this.uselevel) {
            ctorArgClasses[0] = Integer.TYPE;
        }
        for (int idx = 0; idx < itemCtorArgs.length; ++idx) {
            ctorArgClasses[idx + (this.uselevel ? 1 : 0)] = itemCtorArgs[idx].getClass();
        }
        try {
            this.itemCtor = effectclass.getConstructor(ctorArgClasses);
        }
        catch (Exception e) {
            LoggerUtils.error("Caught an exception during instability registration", new Object[0]);
            LoggerUtils.error(e.toString(), new Object[0]);
            throw new RuntimeException("Error when building generic instability effect from effect class " + effectclass.getCanonicalName(), e);
        }
    }

    @Override
    public void addEffects(IInstabilityController controller, Integer level) {
        try {
            Object[] args = this.itemCtorArgs;
            if (this.uselevel) {
                args = ObjectArrays.concat((Object)level, (Object[])this.itemCtorArgs);
            }
            for (int i = 0; i < (this.uselevel ? 1 : level); ++i) {
                IEnvironmentalEffect effect = this.itemCtor.newInstance(args);
                controller.registerEffect(effect);
            }
        }
        catch (Exception e) {
            LoggerUtils.error("Caught an exception during instability usage", new Object[0]);
            throw new RuntimeException("Error when building generic instability effect from effect class " + this.effectclass.getCanonicalName() + " with args " + this.itemCtorArgs, e);
        }
    }
}

