/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability;

import com.google.common.collect.HashMultiset;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.instability.Deck;
import com.xcompwiz.mystcraft.instability.IInstabilityController;
import com.xcompwiz.mystcraft.instability.IInstabilityProvider;
import com.xcompwiz.mystcraft.instability.InstabilityManager;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.storage.StorageInstabilityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;

public class InstabilityController
implements IInstabilityController {
    private AgeController controller;
    private StorageInstabilityData deckdata;
    private boolean enabled;
    private int lastScore;
    private Collection<Deck> decks;
    private HashMap<String, Integer> providerlevels = new HashMap();
    private Collection<IEnvironmentalEffect> effects = new ArrayList<IEnvironmentalEffect>();
    private WorldProviderMyst worldprovider;

    public InstabilityController(WorldProviderMyst provider, AgeController controller) {
        this.worldprovider = provider;
        this.controller = controller;
        this.enabled = controller.isInstabilityEnabled();
        this.deckdata = this.getDataStorage(provider);
        this.buildDecks();
        this.reconstruct();
    }

    private StorageInstabilityData getDataStorage(WorldProviderMyst provider) {
        StorageInstabilityData data = (StorageInstabilityData)provider.field_76579_a.perWorldStorage.func_75742_a(StorageInstabilityData.class, "MystInstabilityData");
        if (data == null) {
            data = new StorageInstabilityData("MystInstabilityData");
            provider.field_76579_a.perWorldStorage.func_75745_a("MystInstabilityData", (WorldSavedData)data);
        }
        data.setAgeData(provider.agedata);
        return data;
    }

    private void buildDecks() {
        this.decks = InstabilityManager.createDecks();
        Random rand = new Random(this.controller.getSeed());
        for (Deck deck : this.decks) {
            String deckname = deck.getName();
            HashMultiset cards = HashMultiset.create(deck.getCards());
            deck.removeAll();
            Collection<String> order = this.deckdata.getDeck(deckname);
            boolean dirty = false;
            for (String card : order) {
                if (cards.remove(card)) {
                    deck.putOnBottom(card);
                    continue;
                }
                dirty = true;
            }
            if (cards.size() > 0) {
                Deck newdeck = new Deck("temp", (Collection<String>)cards);
                newdeck.shuffle(rand);
                deck.putOnBottom(newdeck);
                dirty = true;
            }
            if (!dirty) continue;
            this.deckdata.updateDeck(deck);
        }
    }

    private void validate() {
        if (this.enabled != this.controller.isInstabilityEnabled()) {
            this.enabled = this.controller.isInstabilityEnabled();
            this.reconstruct();
            return;
        }
        int newscore = this.controller.getInstabilityScore();
        if ((newscore -= newscore % InstabilityManager.getSmallestCost()) != this.lastScore) {
            this.lastScore = newscore;
            this.reconstruct();
        }
    }

    private void reconstruct() {
        this.providerlevels.clear();
        this.effects.clear();
        if (!this.enabled) {
            return;
        }
        for (Deck deck : this.decks) {
            Collection<String> providernames = this.getProviders(deck);
            if (providernames == null) continue;
            for (String name : providernames) {
                this.addProviderLevel(name);
            }
        }
        this.rebuildEffects();
    }

    private Collection<String> getProviders(Deck deck) {
        String card;
        int cost;
        int instabilityScore = this.getInstabilityScore();
        if ((instabilityScore -= InstabilityManager.getDeckCost(deck.getName())) < 0) {
            return null;
        }
        ArrayList<String> providers = new ArrayList<String>();
        Iterator<String> i$ = deck.getCards().iterator();
        while (i$.hasNext() && (instabilityScore -= (cost = InstabilityManager.getCardCost(card = i$.next()))) >= 0) {
            providers.add(card);
        }
        return providers;
    }

    private void addProviderLevel(String provider) {
        Integer level = this.providerlevels.get(provider);
        if (level == null) {
            level = 0;
        }
        this.providerlevels.put(provider, level + 1);
    }

    private void rebuildEffects() {
        this.effects.clear();
        for (String name : this.providerlevels.keySet()) {
            IInstabilityProvider provider = InstabilityManager.getProvider(name);
            Integer level = this.providerlevels.get(name);
            if (provider == null || level == null) continue;
            provider.addEffects(this, level);
        }
    }

    public void tick(World world, Chunk chunk) {
        this.validate();
        if (!this.enabled) {
            return;
        }
        if (this.effects != null && this.effects.size() > 0) {
            for (IEnvironmentalEffect effect : this.effects) {
                effect.tick(world, chunk);
            }
        }
    }

    @Override
    public int getInstabilityScore() {
        return this.lastScore;
    }

    @Override
    public void registerEffect(IEnvironmentalEffect effect) {
        this.effects.add(effect);
    }
}

