/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.error;

import com.xcompwiz.mystcraft.client.gui.error.GuiNonCriticalError;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;

public class MystcraftStartupChecker {
    private HashSet<ErrorChecker> checks = new HashSet();

    public MystcraftStartupChecker() {
        this.checks.add(new CheckSymbolLoadError());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiMainMenu && !this.checkForErrors()) {
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }

    private boolean checkForErrors() {
        for (ErrorChecker check : this.checks) {
            if (check.hasRun() || !check.run()) continue;
            return true;
        }
        return false;
    }

    public static class CheckSymbolLoadError
    extends ErrorChecker {
        @Override
        protected GuiScreen getErrorGui() {
            HashSet<String> errored = SymbolManager.getErroredSymbols();
            if (!errored.isEmpty()) {
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("WARNING: Mystcraft detected errors in the following symbols on loadup.");
                messages.add("These symbols are not loaded and will not occur in the game.");
                messages.add("Please check your setup and attempt to get a log of this session to the symbol developer.");
                messages.add("To prevent this message from coming up in the future, disable or remove these symbols.");
                messages.add("");
                messages.addAll(errored);
                return new GuiNonCriticalError(messages);
            }
            return null;
        }
    }

    public static abstract class ErrorChecker {
        private boolean hasRun = false;

        public final boolean hasRun() {
            return this.hasRun;
        }

        public final boolean run() {
            this.hasRun = true;
            GuiScreen gui = this.getErrorGui();
            if (gui != null) {
                Minecraft.func_71410_x().func_147108_a(gui);
                return true;
            }
            return false;
        }

        protected abstract GuiScreen getErrorGui();
    }
}

