/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.entity;

import com.xcompwiz.mystcraft.api.event.MeteorEvent;
import com.xcompwiz.mystcraft.client.audio.MovingSoundMeteor;
import com.xcompwiz.mystcraft.explosion.ExplosionAdvanced;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectBasic;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectBreakBlocks;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectFire;
import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectPlaceOres;
import com.xcompwiz.mystcraft.network.MPacketExplosion;
import com.xcompwiz.mystcraft.network.MPacketParticles;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class EntityMeteor
extends Entity
implements IEntityAdditionalSpawnData {
    private byte inGroundTime;
    private float scale;
    private int penetration;
    private boolean updated = false;

    public EntityMeteor(World worldObj) {
        super(worldObj);
        this.setScale(1.0f, 0);
        this.field_70155_l = 80.0;
        this.field_70129_M = 0.0f;
    }

    public EntityMeteor(World worldObj, float scale, int penetration, double x, double y, double z, double dx, double dy, double dz) {
        this(worldObj);
        this.setScale(scale, penetration);
        this.func_70107_b(x, y, z);
        this.field_70159_w = dx;
        this.field_70181_x = dy;
        this.field_70179_y = dz;
        this.inGroundTime = 0;
        MinecraftForge.EVENT_BUS.post((Event)new MeteorEvent.MetorSpawn(this));
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70128_L = true;
        this.inGroundTime = compound.func_74771_c("InGround");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74774_a("InGround", this.inGroundTime);
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70015_d(1);
        if (!this.updated) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            if (this.field_70170_p.field_72995_K) {
                this.spawnMovingSound();
            }
            this.updated = true;
        }
        Vec3 var15 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 var2 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition var3 = this.field_70170_p.func_72933_a(var15, var2);
        var15 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        if (var3 != null) {
            this.inGroundTime = (byte)(this.inGroundTime + 1);
            this.onImpact(var3);
        } else {
            this.inGroundTime = (byte)(this.inGroundTime - 1);
            this.inGroundTime = (byte)Math.max(0, this.inGroundTime);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float var16 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var16) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            for (int var19 = 0; var19 < 4; ++var19) {
                float var18 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var18, this.field_70163_u - this.field_70181_x * (double)var18, this.field_70161_v - this.field_70179_y * (double)var18, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnMovingSound() {
        if (this.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundMeteor(this));
        }
    }

    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70181_x *= 0.9;
            if (par1MovingObjectPosition.field_72308_g != null) {
                // empty if block
            }
            this.breakBlocksInAABB(this.field_70121_D);
            if (this.inGroundTime >= this.penetration) {
                this.newExplosion(this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, false, true);
                this.newExplosion(this, this.field_70165_t, this.field_70163_u - (double)(this.scale / 10.0f), this.field_70161_v, this.scale, false, true);
                this.newExplosion(this, this.field_70165_t, this.field_70163_u - (double)(this.scale / 5.0f), this.field_70161_v, this.scale * 2.0f, false, true);
                this.newExplosion(this, this.field_70165_t, this.field_70163_u - (double)(this.scale * 2.0f / 5.0f), this.field_70161_v, this.scale, false, true);
                this.newExplosion(this, this.field_70165_t + (double)(this.scale * 4.0f / 5.0f), this.field_70163_u, this.field_70161_v, this.scale, true, false);
                this.newExplosion(this, this.field_70165_t - (double)(this.scale * 4.0f / 5.0f), this.field_70163_u, this.field_70161_v, this.scale, true, false);
                this.newExplosion(this, this.field_70165_t, this.field_70163_u, this.field_70161_v + (double)(this.scale * 4.0f / 5.0f), this.scale, true, false);
                this.newExplosion(this, this.field_70165_t, this.field_70163_u, this.field_70161_v - (double)(this.scale * 4.0f / 5.0f), this.scale, true, false);
                MinecraftForge.EVENT_BUS.post((Event)new MeteorEvent.MetorImpact(this));
                this.func_70106_y();
            }
        }
    }

    private ExplosionAdvanced newExplosion(Entity entity, double posX, double posY, double posZ, float power, boolean isFlaming, boolean addOres) {
        World worldObj = entity.field_70170_p;
        ExplosionAdvanced explosion = new ExplosionAdvanced(worldObj, entity, posX, posY, posZ, power);
        explosion.effects.add(ExplosionEffectBasic.instance);
        explosion.effects.add(ExplosionEffectBreakBlocks.noDrop);
        if (isFlaming) {
            explosion.effects.add(ExplosionEffectFire.instance);
        }
        if (addOres) {
            explosion.effects.add(ExplosionEffectPlaceOres.instance);
        }
        explosion.doExplosionA();
        explosion.doExplosionB(false);
        for (EntityPlayerMP player : worldObj.field_73010_i) {
            if (!(player.func_70092_e(posX, posY, posZ) < 4096.0)) continue;
            player.field_71135_a.func_147359_a((Packet)MPacketExplosion.createPacket((EntityPlayer)player, explosion));
        }
        MinecraftForge.EVENT_BUS.post((Event)new MeteorEvent.MetorExplosion((Entity)this, explosion.blocks));
        return explosion;
    }

    private boolean breakBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int var2 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72340_a + this.field_70159_w));
        int var3 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72338_b + this.field_70181_x));
        int var4 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72339_c + this.field_70179_y));
        int var5 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + this.field_70159_w));
        int var6 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 5.0 + this.field_70181_x));
        int var7 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + this.field_70179_y));
        boolean brokeblocks = false;
        for (int var10 = var2; var10 <= var5; ++var10) {
            for (int var11 = var3; var11 <= var6; ++var11) {
                for (int var12 = var4; var12 <= var7; ++var12) {
                    if (this.field_70170_p.func_147437_c(var10, var11, var12)) continue;
                    brokeblocks = true;
                    this.field_70170_p.func_147465_d(var10, var11, var12, Blocks.field_150350_a, 0, 3);
                }
            }
        }
        if (brokeblocks) {
            FMLProxyPacket pkt = MPacketParticles.createPacket(this, "largeexplode");
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                server.func_71203_ab().func_148537_a((Packet)pkt, this.field_70170_p.field_73011_w.field_76574_g);
            }
        }
        return brokeblocks;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public void setScale(float scale, int penetration) {
        this.scale = scale;
        this.penetration = penetration;
        this.func_70105_a(scale, scale);
    }

    public float getScale() {
        return this.scale;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeFloat(this.scale);
    }

    public void readSpawnData(ByteBuf data) {
        this.setScale(data.readFloat(), 0);
    }
}

