/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.internal.IGrammarAPI;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.util.CollectionUtils;
import java.util.ArrayList;

public class SymbolRules {
    public static void initialize() {
        SymbolRules.addRule("ModNorth", SymbolRules.buildRule(1.0f, "AngleBasic", "ModNorth"));
        SymbolRules.addRule("ModSouth", SymbolRules.buildRule(1.0f, "AngleBasic", "ModSouth"));
        SymbolRules.addRule("ModEast", SymbolRules.buildRule(1.0f, "AngleBasic", "ModEast"));
        SymbolRules.addRule("ModWest", SymbolRules.buildRule(1.0f, "AngleBasic", "ModWest"));
        SymbolRules.addRule("ModRising", SymbolRules.buildRule(1.0f, "PhaseBasic", "ModRising"));
        SymbolRules.addRule("ModNoon", SymbolRules.buildRule(1.0f, "PhaseBasic", "ModNoon"));
        SymbolRules.addRule("ModSetting", SymbolRules.buildRule(1.0f, "PhaseBasic", "ModSetting"));
        SymbolRules.addRule("ModEnd", SymbolRules.buildRule(1.0f, "PhaseBasic", "ModEnd"));
        SymbolRules.addRule("ModZero", SymbolRules.buildRule(0.5f, "PeriodBasic", "ModZero"));
        SymbolRules.addRule("ModHalf", SymbolRules.buildRule(1.0f, "PeriodBasic", "ModHalf"));
        SymbolRules.addRule("ModFull", SymbolRules.buildRule(1.0f, "PeriodBasic", "ModFull"));
        SymbolRules.addRule("ModDouble", SymbolRules.buildRule(1.0f, "PeriodBasic", "ModDouble"));
        SymbolRules.addRule("ModGradient", SymbolRules.buildRule(1.0f, "GradientBasic", "Color", "Period", "ModGradient"));
        SymbolRules.addRule("ColorHorizon", SymbolRules.buildRule(0.5f, "Sunset", "Sunset_Ext", "Gradient", "ColorHorizon"));
        SymbolRules.addRule("NoSea", SymbolRules.buildRule(0.4f, IGrammarAPI.BLOCK_SEA, "NoSea"));
        SymbolRules.addRule("WeatherOff", SymbolRules.buildRule(0.7f, "Weather", "WeatherOff"));
        SymbolRules.addRule("WeatherStorm", SymbolRules.buildRule(0.7f, "Weather", "WeatherStorm"));
        SymbolRules.addRule("WeatherSnow", SymbolRules.buildRule(0.7f, "Weather", "WeatherSnow"));
        SymbolRules.addRule("WeatherRain", SymbolRules.buildRule(0.7f, "Weather", "WeatherRain"));
        SymbolRules.addRule("WeatherCloudy", SymbolRules.buildRule(0.7f, "Weather", "WeatherCloudy"));
        SymbolRules.addRule("WeatherOn", SymbolRules.buildRule(0.7f, "Weather", "WeatherOn"));
        SymbolRules.addRule("WeatherSlow", SymbolRules.buildRule(0.8f, "Weather", "WeatherSlow"));
        SymbolRules.addRule("WeatherNorm", SymbolRules.buildRule(1.0f, "Weather", "WeatherNorm"));
        SymbolRules.addRule("WeatherFast", SymbolRules.buildRule(0.8f, "Weather", "WeatherFast"));
        SymbolRules.addRule("Void", SymbolRules.buildRule(0.0f, "TerrainGen", "Void"));
        SymbolRules.addRule("TerrainNormal", SymbolRules.buildRule(1.0f, "TerrainGen", IGrammarAPI.BLOCK_TERRAIN, IGrammarAPI.BLOCK_SEA, "TerrainNormal"));
        SymbolRules.addRule("TerrainAmplified", SymbolRules.buildRule(1.0f, "TerrainGen", IGrammarAPI.BLOCK_TERRAIN, IGrammarAPI.BLOCK_SEA, "TerrainAmplified"));
        SymbolRules.addRule("TerrainNether", SymbolRules.buildRule(0.3f, "TerrainGen", IGrammarAPI.BLOCK_TERRAIN, IGrammarAPI.BLOCK_SEA, "TerrainNether"));
        SymbolRules.addRule("Flat", SymbolRules.buildRule(0.5f, "TerrainGen", IGrammarAPI.BLOCK_TERRAIN, IGrammarAPI.BLOCK_SEA, "Flat"));
        SymbolRules.addRule("TerrainEnd", SymbolRules.buildRule(0.3f, "TerrainGen", IGrammarAPI.BLOCK_TERRAIN, IGrammarAPI.BLOCK_SEA, "TerrainEnd"));
        SymbolRules.addRule("LightingNormal", SymbolRules.buildRule(1.0f, "Lighting", "LightingNormal"));
        SymbolRules.addRule("LightingDark", SymbolRules.buildRule(0.5f, "Lighting", "LightingDark"));
        SymbolRules.addRule("LightingBright", SymbolRules.buildRule(0.5f, "Lighting", "LightingBright"));
        SymbolRules.addRule("ColorFog", SymbolRules.buildRule(1.5f, "Visual", "Gradient", "ColorFog"));
        SymbolRules.addRule("ColorSkyNight", SymbolRules.buildRule(1.0f, "Visual", "Gradient", "ColorSkyNight"));
        SymbolRules.addRule("ColorSky", SymbolRules.buildRule(2.0f, "Visual", "Gradient", "ColorSky"));
        SymbolRules.addRule("ColorCloud", SymbolRules.buildRule(1.5f, "Visual", "Gradient", "ColorCloud"));
        SymbolRules.addRule("ColorGrass", SymbolRules.buildRule(0.2f, "Visual", "Color", "ColorGrass"));
        SymbolRules.addRule("ColorFoliage", SymbolRules.buildRule(0.2f, "Visual", "Color", "ColorFoliage"));
        SymbolRules.addRule("ColorWater", SymbolRules.buildRule(0.2f, "Visual", "Color", "ColorWater"));
        SymbolRules.addRule("ColorFogNat", SymbolRules.buildRule(1.5f, "Visual", "ColorFogNat"));
        SymbolRules.addRule("ColorSkyNat", SymbolRules.buildRule(2.0f, "Visual", "ColorSkyNat"));
        SymbolRules.addRule("ColorCloudNat", SymbolRules.buildRule(1.5f, "Visual", "ColorCloudNat"));
        SymbolRules.addRule("ColorGrassNat", SymbolRules.buildRule(0.2f, "Visual", "ColorGrassNat"));
        SymbolRules.addRule("ColorFoliageNat", SymbolRules.buildRule(0.2f, "Visual", "ColorFoliageNat"));
        SymbolRules.addRule("ColorWaterNat", SymbolRules.buildRule(0.2f, "Visual", "ColorWaterNat"));
        SymbolRules.addRule("NoHorizon", SymbolRules.buildRule(0.2f, "Visual", "NoHorizon"));
        SymbolRules.addRule("Rainbow", SymbolRules.buildRule(0.1f, "Visual", "Angle", "Rainbow"));
        SymbolRules.addRule("EnvScorch", SymbolRules.buildRule(0.0f, "Effect", "EnvScorch"));
        SymbolRules.addRule("EnvMeteor", SymbolRules.buildRule(0.0f, "Effect", "EnvMeteor"));
        SymbolRules.addRule("EnvLightning", SymbolRules.buildRule(0.1f, "Effect", "Gradient", "EnvLightning"));
        SymbolRules.addRule("EnvExplosions", SymbolRules.buildRule(0.0f, "Effect", "EnvExplosions"));
        SymbolRules.addRule("EnvAccel", SymbolRules.buildRule(0.0f, "Effect", "EnvAccel"));
        SymbolRules.addRule("StarsEndSky", SymbolRules.buildRule(0.3f, "Starfield", "Gradient", "StarsEndSky"));
        SymbolRules.addRule("StarsNormal", SymbolRules.buildRule(2.0f, "Starfield", "Gradient", "Period", "Angle", "StarsNormal"));
        SymbolRules.addRule("StarsTwinkle", SymbolRules.buildRule(1.0f, "Starfield", "Gradient", "Period", "Angle", "StarsTwinkle"));
        SymbolRules.addRule("StarsDark", SymbolRules.buildRule(0.2f, "Starfield", "StarsDark"));
        SymbolRules.addRule("SunNormal", SymbolRules.buildRule(2.0f, "Sun", "Sunset", "Period", "Angle", "Phase", "SunNormal"));
        SymbolRules.addRule("SunDark", SymbolRules.buildRule(0.2f, "Sun", "SunDark"));
        SymbolRules.addRule("MoonNormal", SymbolRules.buildRule(2.0f, "Moon", "SunsetUncommon", "Period", "Angle", "Phase", "MoonNormal"));
        SymbolRules.addRule("MoonDark", SymbolRules.buildRule(0.2f, "Moon", "MoonDark"));
        SymbolRules.addRule("BioConNative", SymbolRules.buildRule(0.0f, "BiomeController", "BioConNative"));
        SymbolRules.addRule("BioConSingle", SymbolRules.buildRule(0.7f, "BiomeController", "Biome", "BioConSingle"));
        SymbolRules.addRule("BioConTiled", SymbolRules.buildRule(0.8f, "BiomeController", "Biomes", "Biome", "BioConTiled"));
        SymbolRules.addRule("BioConGrid", SymbolRules.buildRule(0.8f, "BiomeController", "Biomes", "Biome", "BioConGrid"));
        SymbolRules.addRule("BioConTiny", SymbolRules.buildRule(0.8f, "BiomeController", "Biomes", "Biome", "Biome", "BioConTiny"));
        SymbolRules.addRule("BioConSmall", SymbolRules.buildRule(0.9f, "BiomeController", "Biomes", "Biome", "Biome", "BioConSmall"));
        SymbolRules.addRule("BioConMedium", SymbolRules.buildRule(1.0f, "BiomeController", "Biomes", "Biome", "Biome", "BioConMedium"));
        SymbolRules.addRule("BioConLarge", SymbolRules.buildRule(0.8f, "BiomeController", "Biomes", "Biome", "Biome", "BioConLarge"));
        SymbolRules.addRule("BioConHuge", SymbolRules.buildRule(0.8f, "BiomeController", "Biomes", "Biome", "Biome", "BioConHuge"));
        SymbolRules.addRule("FloatIslands", SymbolRules.buildRule(0.4f, "TerrainAlt", "Biome", IGrammarAPI.BLOCK_STRUCTURE, "FloatIslands"));
        SymbolRules.addRule("Tendrils", SymbolRules.buildRule(0.3f, "TerrainAlt", IGrammarAPI.BLOCK_STRUCTURE, "Tendrils"));
        SymbolRules.addRule("Skylands", SymbolRules.buildRule(0.1f, "TerrainAlt", "Skylands"));
        SymbolRules.addRule("Ravines", SymbolRules.buildRule(2.0f, "TerrainAlt", "Ravines"));
        SymbolRules.addRule("Caves", SymbolRules.buildRule(2.0f, "TerrainAlt", "Caves"));
        SymbolRules.addRule("TerModSpheres", SymbolRules.buildRule(0.5f, "TerrainAlt", IGrammarAPI.BLOCK_STRUCTURE, "TerModSpheres"));
        SymbolRules.addRule("NetherFort", SymbolRules.buildRule(0.5f, "Populator", "NetherFort"));
        SymbolRules.addRule("Villages", SymbolRules.buildRule(1.0f, "Populator", "Villages"));
        SymbolRules.addRule("Strongholds", SymbolRules.buildRule(1.0f, "Populator", "Strongholds"));
        SymbolRules.addRule("Mineshafts", SymbolRules.buildRule(1.0f, "Populator", "Mineshafts"));
        SymbolRules.addRule("Dungeons", SymbolRules.buildRule(1.0f, "Populator", "Dungeons"));
        SymbolRules.addRule("Obelisks", SymbolRules.buildRule(0.6f, "Populator", IGrammarAPI.BLOCK_STRUCTURE, "Obelisks"));
        SymbolRules.addRule("DenseOres", SymbolRules.buildRule(0.0f, "Populator", "DenseOres"));
        SymbolRules.addRule("StarFissure", SymbolRules.buildRule(0.3f, "Populator", "StarFissure"));
        SymbolRules.addRule("LakesSurface", SymbolRules.buildRule(1.0f, "Populator", IGrammarAPI.BLOCK_FLUID, "LakesSurface"));
        SymbolRules.addRule("LakesDeep", SymbolRules.buildRule(1.0f, "Populator", "BLOCK_NONSOLID", "LakesDeep"));
        SymbolRules.addRule("HugeTrees", SymbolRules.buildRule(0.1f, "Populator", "HugeTrees"));
        SymbolRules.addRule("GenSpikes", SymbolRules.buildRule(0.6f, "Populator", IGrammarAPI.BLOCK_STRUCTURE, "GenSpikes"));
        SymbolRules.addRule("CryForm", SymbolRules.buildRule(0.6f, "Populator", IGrammarAPI.BLOCK_CRYSTAL, "CryForm"));
    }

    public static void register() {
        ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
        for (IAgeSymbol symbol2 : symbols) {
            ArrayList<GrammarGenerator.Rule> rules;
            if (!(symbol2 instanceof SymbolBase) || (rules = ((SymbolBase)symbol2).getRules()) == null) continue;
            for (GrammarGenerator.Rule rule : rules) {
                GrammarGenerator.registerRule(rule);
            }
        }
    }

    private static void addRule(String string, GrammarGenerator.Rule rule) {
        IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(string);
        if (string == null) {
            LoggerUtils.info("Failed to add rule to symbol " + string, new Object[0]);
            return;
        }
        if (symbol2 instanceof SymbolBase) {
            ((SymbolBase)symbol2).addRule(rule);
        }
    }

    private static GrammarGenerator.Rule buildRule(float rarity, String parent, String ... args) {
        ArrayList<String> list = CollectionUtils.buildList(args);
        return new GrammarGenerator.Rule(parent, list, rarity);
    }
}

