/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.data.SymbolDataModifiers;
import com.xcompwiz.mystcraft.world.ChunkProfiler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class SymbolDataFluids {
    private static Map<String, FluidData> defaults = new HashMap<String, FluidData>();
    private static FluidData defaultfluidvals = new FluidData();
    private static Map<String, Boolean> bannedsea = new HashMap<String, Boolean>();
    private static Map<String, Float> rarities = new HashMap<String, Float>();
    private static Map<String, Float> grammarWeights = new HashMap<String, Float>();
    private static Map<String, Float> factor1s = new HashMap<String, Float>();
    private static Map<String, Float> factor2s = new HashMap<String, Float>();
    private static MystConfig config;

    public static void setConfig(MystConfig mystconfig) {
        config = mystconfig;
    }

    public static FluidData getDefault(String fluidname) {
        FluidData data = defaults.get(fluidname);
        if (data == null) {
            data = new FluidData();
            defaults.put(fluidname, data);
        }
        return data;
    }

    public static void init() {
        SymbolDataFluids.getDefault("fluid.mobessence").setBannedSea(false).setFactor1(98.0f).setFactor2(7.0f);
        SymbolDataFluids.getDefault("fluid.ender").setBannedSea(true).setFactor1(72.0f).setFactor2(6.0f);
        SymbolDataFluids.getDefault("fluid.manyullyn.molten").setBannedSea(true).setFactor1(72.0f).setFactor2(6.0f);
        SymbolDataFluids.getDefault("fluid.redstone").setBannedSea(true).setFactor1(72.0f).setFactor2(6.0f);
        SymbolDataFluids.getDefault("fluid.fluiduumatter").setBannedSea(true).setFactor1(32.0f).setFactor2(4.0f);
        SymbolDataFluids.getDefault("fluid.life_essence").setBannedSea(false).setFactor1(32.0f).setFactor2(4.0f);
        SymbolDataFluids.getDefault("fluid.alumite.molten").setBannedSea(true).setFactor1(18.0f).setFactor2(3.0f);
        SymbolDataFluids.getDefault("fluid.ardite.molten").setBannedSea(true).setFactor1(18.0f).setFactor2(3.0f);
        SymbolDataFluids.getDefault("fluid.cobalt.molten").setBannedSea(true).setFactor1(18.0f).setFactor2(3.0f);
        SymbolDataFluids.getDefault("fluid.fluid.purity").setBannedSea(false).setFactor1(18.0f).setFactor2(3.0f);
        SymbolDataFluids.getDefault("fluid.aluminum.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.biofuel").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.bronze.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.chocolatemilk").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.copper.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.creosote").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.electrum.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.emerald.liquid").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.fluidbiogas").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.fluidbiomass").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.fuel").setBannedSea(false).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.gold.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.invar.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.iron.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.lead.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.nickel.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.obsidian.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.platinum.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.silver.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.steel.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.tin.molten").setBannedSea(true).setFactor1(8.0f).setFactor2(2.0f);
        SymbolDataFluids.getDefault("fluid.aluminumbrass.molten").setBannedSea(true).setFactor1(2.0f).setFactor2(1.0f);
        SymbolDataFluids.getDefault("fluid.coal").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        SymbolDataFluids.getDefault("fluid.glass.molten").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        SymbolDataFluids.getDefault("fluid.glowstone").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        SymbolDataFluids.getDefault("fluid.honey").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.oil").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.spring_water").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        SymbolDataFluids.getDefault("fluid.witchery:fluidspirit").setBannedSea(false).setFactor1(2.0f).setFactor2(1.0f);
        SymbolDataFluids.getDefault("fluid.meat").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.myst.ink.black").setBannedSea(false).setFactor1(1.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.blood").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.fluidconstructionfoam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.fluidcoolant").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.fluiddistilledwater").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.fluidpahoehoelava").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.fluidsteam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.fluidsuperheatedsteam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.glue").setBannedSea(true).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.milk").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.mushroomsoup").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.steam").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.stone.seared").setBannedSea(false).setFactor1(0.0f).setFactor2(0.0f);
        SymbolDataFluids.getDefault("fluid.slime.blue").setBannedSea(false).setFactor1(-0.5f).setFactor2(-0.5f);
        SymbolDataFluids.getDefault("fluid.cryotheum").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.etchacid").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.fluid.death").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.fluidhotcoolant").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.poison").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.sewage").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.sludge").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.witchery:hollowtears").setBannedSea(false).setFactor1(-2.0f).setFactor2(-1.0f);
        SymbolDataFluids.getDefault("fluid.mana").setBannedSea(false).setFactor1(-6.0f).setFactor2(-2.0f);
        SymbolDataFluids.getDefault("fluid.pyrotheum").setBannedSea(false).setFactor1(-6.0f).setFactor2(-2.0f);
        SymbolDataFluids.getDefault("fluid.fluxgoo").setBannedSea(false).setFactor1(-12.0f).setFactor2(-3.0f);
    }

    public static void modsLoaded() {
        Map map = FluidRegistry.getRegisteredFluids();
        for (Map.Entry entry : map.entrySet()) {
            Fluid fluid = (Fluid)entry.getValue();
            Block block = fluid.getBlock();
            if (block == Blocks.field_150355_j || block == Blocks.field_150353_l || block == null || Item.func_150898_a((Block)block) == null) continue;
            byte meta = 0;
            if (block instanceof BlockFluidBase) {
                meta = (byte)((BlockFluidBase)block).getMaxRenderHeightMeta();
            }
            String fluidkey = SymbolDataFluids.getFluidKey(fluid);
            SymbolDataModifiers.BlockModifierContainerObject container = SymbolDataModifiers.BlockModifierContainerObject.create("Flow", SymbolDataFluids.symbolRarity(fluidkey), block, meta);
            ChunkProfiler.setInstabilityFactors(block, SymbolDataFluids.factor1(fluidkey), SymbolDataFluids.factor2(fluidkey), 0);
            if (fluid.isGaseous()) {
                container.add(BlockCategory.GAS, SymbolDataFluids.grammarWeight(fluidkey));
                continue;
            }
            if (!SymbolDataFluids.isBannedSea(fluidkey)) {
                container.add(BlockCategory.SEA, SymbolDataFluids.grammarWeight(fluidkey));
            }
            container.add(BlockCategory.FLUID, SymbolDataFluids.grammarWeight(fluidkey));
        }
        if (config != null && config.hasChanged()) {
            config.save();
        }
    }

    private static FluidData getDefaultValue(String fluidkey) {
        FluidData data = defaults.get(fluidkey);
        if (data != null) {
            return data;
        }
        return defaultfluidvals;
    }

    private static boolean isBannedSea(String fluidkey) {
        Boolean value = bannedsea.get(fluidkey);
        if (value != null) {
            return value;
        }
        boolean val = SymbolDataFluids.getDefaultValue((String)fluidkey).seabanned;
        if (config != null) {
            return config.getOptional("balance", fluidkey + ".seabanned", val);
        }
        return val;
    }

    private static float symbolRarity(String fluidkey) {
        Float value = rarities.get(fluidkey);
        if (value != null) {
            return value.floatValue();
        }
        float val = SymbolDataFluids.getDefaultValue((String)fluidkey).rarity;
        if (config != null) {
            return config.getOptional("balance", fluidkey + ".rarity", val);
        }
        return val;
    }

    private static float grammarWeight(String fluidkey) {
        Float value = grammarWeights.get(fluidkey);
        if (value != null) {
            return value.floatValue();
        }
        float val = SymbolDataFluids.getDefaultValue((String)fluidkey).grammar;
        if (config != null) {
            return config.getOptional("balance", fluidkey + ".grammar", val);
        }
        return val;
    }

    private static float factor1(String fluidkey) {
        Float value = factor1s.get(fluidkey);
        if (value != null) {
            return value.floatValue();
        }
        float val = SymbolDataFluids.getDefaultValue((String)fluidkey).factor1;
        if (config != null) {
            return config.getOptional("balance", fluidkey + ".instability.factor_accessibility", val);
        }
        return val;
    }

    private static float factor2(String fluidkey) {
        Float value = factor2s.get(fluidkey);
        if (value != null) {
            return value.floatValue();
        }
        float val = SymbolDataFluids.getDefaultValue((String)fluidkey).factor2;
        if (config != null) {
            return config.getOptional("balance", fluidkey + ".instability.factor_flat", val);
        }
        return val;
    }

    private static String getFluidKey(Fluid fluid) {
        return fluid.getUnlocalizedName().toLowerCase().replace(' ', '_');
    }

    public static void setSeaBanned(Fluid fluid, boolean value) {
        bannedsea.put(SymbolDataFluids.getFluidKey(fluid), value);
    }

    public static void setRarity(Fluid fluid, float value) {
        rarities.put(SymbolDataFluids.getFluidKey(fluid), Float.valueOf(value));
    }

    public static void setGrammarWeight(Fluid fluid, float value) {
        grammarWeights.put(SymbolDataFluids.getFluidKey(fluid), Float.valueOf(value));
    }

    public static void setFactor1(Fluid fluid, float value) {
        factor1s.put(SymbolDataFluids.getFluidKey(fluid), Float.valueOf(value));
    }

    public static void setFactor2(Fluid fluid, float value) {
        factor2s.put(SymbolDataFluids.getFluidKey(fluid), Float.valueOf(value));
    }

    public static class FluidData {
        public boolean seabanned = false;
        public float grammar = 0.1f;
        public float rarity = 0.1f;
        public float factor1 = 1.0f;
        public float factor2 = 0.25f;

        public FluidData setBannedSea(boolean b) {
            this.seabanned = b;
            return this;
        }

        public FluidData setGrammarW(float v) {
            this.grammar = v;
            return this;
        }

        public FluidData setRarity(float v) {
            this.rarity = v;
            return this;
        }

        public FluidData setFactor1(float v) {
            this.factor1 = v;
            return this;
        }

        public FluidData setFactor2(float v) {
            this.factor2 = v;
            return this;
        }
    }
}

