/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.data;

import com.xcompwiz.mystcraft.core.InternalAPI;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.CreativeTabMyst;
import com.xcompwiz.mystcraft.inventory.InventoryNotebook;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;

public class ModNotebooks {
    public static ItemStack createCreativeNotebook() {
        ItemStack notebook = new ItemStack(ModItems.notebook, 1, 0);
        InventoryNotebook.setName(notebook, "Creative Spawned (All Symbols)");
        ArrayList<IAgeSymbol> symbols = new ArrayList<IAgeSymbol>();
        symbols.addAll(SymbolManager.getAgeSymbols());
        Collections.sort(symbols, SortingUtils.ComparatorSymbolAlphabetical.instance);
        for (IAgeSymbol symbol2 : symbols) {
            InventoryNotebook.addItem(notebook, Page.createSymbolPage(symbol2.identifier()));
        }
        return notebook;
    }

    public static void addNotebooks(CreativeTabMyst mainTab) {
    }

    public static ItemStack buildNotebook(String name, String ... args) {
        return InternalAPI.itemFact.buildNotebook("Spawned (" + name + ")", args);
    }

    public static void addSymbolPages(CreativeTabMyst pageTab) {
        ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
        Collections.sort(symbols, SortingUtils.ComparatorSymbolAlphabetical.instance);
        for (IAgeSymbol symbol2 : symbols) {
            pageTab.registerItemStack(Page.createSymbolPage(symbol2.identifier()));
        }
    }
}

