/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.core;

import com.xcompwiz.mystcraft.api.MystAPI;
import com.xcompwiz.mystcraft.api.internal.IDimensionAPI;
import com.xcompwiz.mystcraft.api.internal.IGrammarAPI;
import com.xcompwiz.mystcraft.api.internal.IRenderAPI;
import com.xcompwiz.mystcraft.api.internal.IWordAPI;
import com.xcompwiz.mystcraft.client.render.RenderAPIDelegate;
import com.xcompwiz.mystcraft.grammar.GrammarAPIDelegate;
import com.xcompwiz.mystcraft.instability.InstabilityAPIDelegate;
import com.xcompwiz.mystcraft.instability.InstabilityFactory;
import com.xcompwiz.mystcraft.item.ItemFactory;
import com.xcompwiz.mystcraft.linking.DimensionAPIDelegate;
import com.xcompwiz.mystcraft.linking.LinkingAPIDelegate;
import com.xcompwiz.mystcraft.page.PageAPIDelegate;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.SymbolAPIDelegate;
import com.xcompwiz.mystcraft.symbol.SymbolFactory;
import java.util.HashMap;

public class InternalAPI {
    public static DimensionAPIDelegate dimension;
    public static LinkingAPIDelegate linking;
    public static LinkingAPIDelegate linkProperties;
    public static InstabilityAPIDelegate instability;
    public static InstabilityFactory instabilityFact;
    public static SymbolAPIDelegate symbol;
    public static SymbolAPIDelegate symbolValues;
    public static GrammarAPIDelegate grammar;
    public static SymbolFactory symbolFact;
    public static PageAPIDelegate page;
    public static ItemFactory itemFact;
    public static RenderAPIDelegate render;
    private static HashMap<String, MystAPI> instances;

    public static void initAPI() {
        SymbolAPIDelegate symbol_delegate;
        LinkingAPIDelegate linking_delegate = new LinkingAPIDelegate();
        dimension = new DimensionAPIDelegate();
        linking = linking_delegate;
        linkProperties = linking_delegate;
        instability = new InstabilityAPIDelegate();
        instabilityFact = new InstabilityFactory();
        symbol = symbol_delegate = new SymbolAPIDelegate();
        symbolValues = symbol_delegate;
        grammar = new GrammarAPIDelegate();
        symbolFact = new SymbolFactory();
        page = new PageAPIDelegate();
        itemFact = new ItemFactory();
        render = new RenderAPIDelegate();
        SortingUtils.ComparatorItemSymbolAlphabetical.instance.compare(null, null);
    }

    public static synchronized MystAPI getAPIInstance(String modId) {
        MystAPI instance = instances.get(modId);
        if (instance == null) {
            instance = InternalAPI.createAPIInstance(modId);
            instances.put(modId, instance);
        }
        return instance;
    }

    private static MystAPI createAPIInstance(String modId) {
        MystAPIInstance mystAPI = new MystAPIInstance(modId);
        return mystAPI;
    }

    static {
        instances = new HashMap();
    }

    public static class MystAPIInstance
    extends MystAPI {
        public final String modId;

        public MystAPIInstance(String modId) {
            this.modId = modId;
        }

        @Override
        public IDimensionAPI getDimensionAPI() {
            return dimension;
        }

        @Override
        public IGrammarAPI getGrammarAPI() {
            return grammar;
        }

        @Override
        public IWordAPI getWordAPI() {
            return symbol;
        }

        @Override
        public IRenderAPI getRenderAPI() {
            return render;
        }
    }
}

