/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.command;

import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class CommandBaseAdv
extends CommandBase {
    public void sendToAdmins(ICommandSender agent, String text, Object[] objects) {
        CommandBaseAdv.func_152373_a((ICommandSender)agent, (ICommand)this, (String)text, (Object[])objects);
    }

    public static EntityPlayerMP getTargetPlayer(ICommandSender sender, String target) {
        EntityPlayerMP entityplayermp = PlayerSelector.func_82386_a((ICommandSender)sender, (String)target);
        if (entityplayermp == null) {
            entityplayermp = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(target);
        }
        if (entityplayermp == null) {
            throw new PlayerNotFoundException();
        }
        return entityplayermp;
    }

    public static World getSenderWorld(ICommandSender sender) {
        try {
            if (sender instanceof CommandBlockLogic) {
                return ((CommandBlockLogic)sender).func_130014_f_();
            }
            EntityPlayerMP player = CommandBaseAdv.func_71521_c((ICommandSender)sender);
            return player.field_70170_p;
        }
        catch (Exception e) {
            try {
                TileEntity comblock = CommandBaseAdv.getCommandSenderAsCommandBlock(sender);
                return comblock.func_145831_w();
            }
            catch (Exception ex) {
                throw new CommandException("This command can only be sent from a player or command block", new Object[0]);
            }
        }
    }

    public static Integer getSenderDimension(ICommandSender sender) {
        try {
            if (sender instanceof CommandBlockLogic) {
                return ((CommandBlockLogic)sender).func_130014_f_().field_73011_w.field_76574_g;
            }
            EntityPlayerMP player = CommandBaseAdv.func_71521_c((ICommandSender)sender);
            return player.field_71093_bK;
        }
        catch (Exception e) {
            try {
                TileEntity comblock = CommandBaseAdv.getCommandSenderAsCommandBlock(sender);
                return comblock.func_145831_w().field_73011_w.field_76574_g;
            }
            catch (Exception ex) {
                throw new CommandException("You must specify a dimension to use this command from the commandline", new Object[0]);
            }
        }
    }

    public static TileEntity getCommandSenderAsCommandBlock(ICommandSender sender) {
        throw new CommandException("Could not get commandblock", new Object[0]);
    }

    public static double handleRelativeNumber(ICommandSender sender, double origin, String arg) {
        return CommandBaseAdv.handleRelativeNumber(sender, origin, arg, -30000000, 30000000);
    }

    public static double handleRelativeNumber(ICommandSender par1ICommandSender, double origin, String arg, int min, int max) {
        double d1;
        boolean relative = arg.startsWith("~");
        boolean random = arg.startsWith("?");
        if (random) {
            relative = true;
        }
        double d = d1 = relative ? origin : 0.0;
        if (!relative || arg.length() > 1) {
            boolean flag1 = arg.contains(".");
            if (relative) {
                arg = arg.substring(1);
            }
            double d2 = CommandBaseAdv.func_82363_b((ICommandSender)par1ICommandSender, (String)arg);
            if (random) {
                Random rand = new Random();
                d1 += (rand.nextDouble() * 2.0 - 1.0) * d2;
            } else {
                d1 += d2;
            }
            if (!flag1 && !relative) {
                d1 += 0.5;
            }
        }
        if (min != 0 || max != 0) {
            if (d1 < (double)min) {
                throw new NumberInvalidException("commands.generic.double.tooSmall", new Object[]{d1, min});
            }
            if (d1 > (double)max) {
                throw new NumberInvalidException("commands.generic.double.tooBig", new Object[]{d1, max});
            }
        }
        return d1;
    }

    public static Entity parsePlayerByName(String name) throws PlayerNotFoundException {
        EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(name);
        if (player != null) {
            return player;
        }
        throw new PlayerNotFoundException(String.format("Could not get Player by name: %s", name), new Object[0]);
    }

    public static float parseFloat(ICommandSender par0ICommandSender, String par1Str) {
        try {
            return Float.parseFloat(par1Str);
        }
        catch (NumberFormatException numberformatexception) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{par1Str});
        }
    }
}

