/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.item.IItemWritable;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiElementNotebookTabs
extends GuiElement {
    private IGuiNotebookTabsHandler listener;
    private static final int windowsizeY = 166;
    private static final byte tabCount = 4;

    public GuiElementNotebookTabs(IGuiNotebookTabsHandler eventhandler, int guiLeft, int guiTop, int width, int height) {
        super(guiLeft, guiTop, width, height);
        this.listener = eventhandler;
    }

    private void cycleNotebookUp() {
        byte topslot = this.getTopSlot();
        if (topslot == 0) {
            return;
        }
        topslot = (byte)(topslot - 1);
        this.listener.setTopNotebookSlot(topslot);
    }

    private void cycleNotebookDown() {
        byte topslot = this.getTopSlot();
        if (topslot == this.getMaxNotebookCount() - 4) {
            return;
        }
        topslot = (byte)(topslot + 1);
        this.listener.setTopNotebookSlot(topslot);
    }

    @Override
    public boolean keyTyped(char c, int i) {
        super.keyTyped(c, i);
        if (i == 200 || i == this.mc.field_71474_y.field_74351_w.func_151463_i()) {
            this.cycleNotebookUp();
            return true;
        }
        if (i == 208 || i == this.mc.field_71474_y.field_74368_y.func_151463_i()) {
            this.cycleNotebookDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        byte topslot = this.getTopSlot();
        int tabY = this.guiTop;
        if (GuiUtils.contains(x, y, this.guiLeft, tabY, 58, 9)) {
            this.cycleNotebookUp();
            return true;
        }
        tabY += 9;
        for (byte slot = topslot; slot < topslot + 4; slot = (byte)(slot + 1)) {
            if (GuiUtils.contains(x, y, this.guiLeft, tabY + 1, 58, 35) && !GuiUtils.contains(x, y, this.guiLeft + 35, tabY + 2, 19, 19)) {
                this.listener.onNotebookTabClick(button, slot);
                return true;
            }
            tabY += 37;
        }
        if (GuiUtils.contains(x, y, this.guiLeft, tabY, 58, 9)) {
            this.cycleNotebookDown();
            return true;
        }
        return false;
    }

    @Override
    public void render(float f, int mouseX, int mouseY) {
        byte topslot = this.getTopSlot();
        int tabY = this.guiTop;
        int xSizeTab = 58;
        int ySizeTab = 37;
        byte activeslot = this.getActiveTab();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (activeslot < topslot) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        }
        if (topslot == 0) {
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        }
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
        this.func_73729_b(this.guiLeft, tabY, 0, 166 + ySizeTab, xSizeTab, 9);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tabY += 9;
        for (byte i = topslot; i < topslot + 4; i = (byte)(i + 1)) {
            if (i == activeslot) {
                GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
            }
            this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
            this.func_73729_b(this.guiLeft, tabY, 0, 166, xSizeTab, ySizeTab);
            GuiUtils.drawWord(this.mc.field_71446_o, this.field_73735_i, DrawableWordManager.getDrawableWord("" + i), 19.0f, this.guiLeft + 8, tabY + 3);
            ItemStack pagesource = this.getTabContents(i);
            if (pagesource != null) {
                String name = null;
                if (pagesource.func_77973_b() instanceof IItemWritable) {
                    name = ((IItemWritable)pagesource.func_77973_b()).getDisplayName((EntityPlayer)this.mc.field_71439_g, pagesource);
                }
                if (name != null) {
                    GL11.glPushMatrix();
                    float scale = 1.0f;
                    int j = this.mc.field_71466_p.func_78256_a(name) + 16;
                    if (j > xSizeTab) {
                        scale = (float)xSizeTab / (float)j;
                    }
                    GL11.glTranslatef((float)(this.guiLeft + 4), (float)(tabY + 25), (float)0.0f);
                    GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                    this.mc.field_71466_p.func_78276_b(name, 0, 0, 0x404040);
                    GL11.glPopMatrix();
                }
            }
            tabY += ySizeTab;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.mc.field_71446_o.func_110577_a(Assets.GUIs.desk);
        if (activeslot >= topslot + 4) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        }
        if (topslot + 4 == this.getMaxNotebookCount()) {
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        }
        this.func_73729_b(this.guiLeft, tabY, 0, 166 + ySizeTab + 9, xSizeTab, 9);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private byte getTopSlot() {
        return this.listener.getTopSlot();
    }

    private byte getActiveTab() {
        return this.listener.getActiveTab();
    }

    private int getMaxNotebookCount() {
        return 25;
    }

    private ItemStack getTabContents(byte slot) {
        return this.listener.getItemInSlot(slot);
    }

    public static interface IGuiNotebookTabsHandler {
        public ItemStack getItemInSlot(byte var1);

        public void setTopNotebookSlot(int var1);

        public void onNotebookTabClick(int var1, byte var2);

        public byte getTopSlot();

        public byte getActiveTab();
    }
}

