/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui;

import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;

public abstract class GuiContainerElements
extends GuiContainer {
    protected List<GuiElement> elements = new ArrayList<GuiElement>();

    public GuiContainerElements(Container container) {
        super(container);
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
        this.elements.clear();
        this.validate();
    }

    public void validate() {
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateElements();
    }

    protected void updateElements() {
        for (GuiElement elem : this.elements) {
            elem.update();
        }
    }

    protected void func_73869_a(char c, int i) {
        for (GuiElement elem : this.elements) {
            if (!elem.keyTyped(c, i)) continue;
            return;
        }
        if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(c, i);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.handleElementMouseInput();
    }

    protected void handleElementMouseInput() {
        for (GuiElement elem : this.elements) {
            elem.handleMouseInput();
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.handleElementMouseClicked(i, j, k);
    }

    protected void handleElementMouseClicked(int i, int j, int k) {
        for (GuiElement elem : this.elements) {
            elem.mouseClicked(i, j, k);
        }
    }

    protected void func_146286_b(int i, int j, int k) {
        super.func_146286_b(i, j, k);
        this.handleElementMouseUp(i, j, k);
    }

    protected void handleElementMouseUp(int i, int j, int k) {
        for (GuiElement elem : this.elements) {
            elem.mouseUp(i, j, k);
        }
    }

    protected void drawElementBackgrounds(float f, int mouseX, int mouseY) {
        for (GuiElement elem : this.elements) {
            if (!elem.isVisible()) continue;
            elem.render(f, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawToolTip(mouseX, mouseY);
        this.drawElementForegrounds(mouseX, mouseY);
    }

    protected void drawElementForegrounds(int mouseX, int mouseY) {
        for (GuiElement elem : this.elements) {
            if (!elem.isVisible()) continue;
            elem.renderForeground(mouseX, mouseY);
        }
    }

    protected void drawToolTip(int mouseX, int mouseY) {
        List<String> tooltip = null;
        for (GuiElement elem : this.elements) {
            if (elem.isVisible() && (tooltip = elem.getTooltipInfo()) != null) break;
        }
        if (tooltip == null) {
            tooltip = this.getTooltipInfo();
        }
        if (tooltip != null) {
            GuiUtils.drawTooltip(this.field_146289_q, mouseX - this.field_147003_i + 12, mouseY - this.field_147009_r - 12, this.field_73735_i, tooltip, this.field_147003_i + this.field_146999_f, this.field_147009_r + this.field_147000_g);
        }
    }

    protected List<String> getTooltipInfo() {
        return null;
    }
}

