/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.EnderTech;
import io.endertech.block.ETBlocks;
import io.endertech.client.handler.DrawBlockHighlightEventHandler;
import io.endertech.client.handler.KeyBindingHandler;
import io.endertech.client.render.IconRegistry;
import io.endertech.modules.dev.fluid.DevETFluids;
import io.endertech.multiblock.handler.MultiblockClientTickHandler;
import io.endertech.multiblock.renderer.ConnectedTextureRenderer;
import io.endertech.multiblock.renderer.TankControllerRenderer;
import io.endertech.multiblock.tile.TileTankController;
import io.endertech.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerTickerHandlers() {
        super.registerTickerHandlers();
        FMLCommonHandler.instance().bus().register((Object)new KeyBindingHandler());
        FMLCommonHandler.instance().bus().register((Object)new MultiblockClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DrawBlockHighlightEventHandler());
    }

    @Override
    public void registerTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankController.class, (TileEntitySpecialRenderer)new TankControllerRenderer());
    }

    @Override
    public void registerItemRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ETBlocks.blockTankController), (IItemRenderer)new TankControllerRenderer());
    }

    @Override
    public void registerRenderers() {
        connectedTexturesRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new ConnectedTextureRenderer());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
        String[] types;
        if (event.map.func_130086_a() == 1) {
            return;
        }
        DevETFluids.fluidChargedEnderStill = event.map.func_94245_a("endertech:fluids/charged_ender_still");
        DevETFluids.fluidChargedEnderFlowing = event.map.func_94245_a("endertech:fluids/charged_ender_flow");
        for (String type : types = new String[]{"Side", "Top", "Bottom"}) {
            if (Loader.isModLoaded((String)"ThermalExpansion")) {
                IconRegistry.addAndRegisterIcon("Machine_Redstone_" + type, "thermalexpansion:machine/Machine_" + type, (IIconRegister)event.map);
            } else {
                IconRegistry.addAndRegisterIcon("Machine_Redstone_" + type, "endertech:machines/Machine_Redstone_" + type, (IIconRegister)event.map);
            }
            IconRegistry.addAndRegisterIcon("Machine_Creative_" + type, "endertech:machines/Machine_Creative_" + type, (IIconRegister)event.map);
            IconRegistry.addAndRegisterIcon("Machine_Resonant_" + type, "endertech:machines/Machine_Resonant_" + type, (IIconRegister)event.map);
        }
        IconRegistry.addAndRegisterIcon("Particle_Health", "endertech:particles/health", (IIconRegister)event.map);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void initializeIcons(TextureStitchEvent.Post event) {
        if (EnderTech.loadDevModeContent && Loader.isModLoaded((String)"ThermalExpansion")) {
            DevETFluids.fluidChargedEnder.setIcons(DevETFluids.fluidChargedEnderStill, DevETFluids.fluidChargedEnderFlowing);
        }
    }
}

