/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.gui.element;

import cofh.lib.gui.element.ElementFluidTank;
import io.endertech.config.GeneralConfig;
import io.endertech.gui.client.GuiETBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class ElementFluidTankSizeable
extends ElementFluidTank {
    public ElementFluidTankSizeable(GuiETBase gui, int posX, int posY, int sizeX, int sizeY, IFluidTank tank) {
        super(gui, posX, posY, tank);
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int amount = this.getScaled();
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        if (fluid.isGaseous(fluidStack) && !GeneralConfig.gasTopToBottom) {
            float opacity = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            if (opacity < 0.1f) {
                opacity = 0.1f;
            }
            ((GuiETBase)this.gui).drawFluidWithOpacity(this.posX, this.posY, this.tank.getFluid(), this.sizeX, this.sizeY, opacity);
        } else {
            this.gui.drawFluid(this.posX, this.posY + this.sizeY - amount, this.tank.getFluid(), this.sizeX, amount);
        }
    }

    int getScaled() {
        return this.tank.getFluidAmount() * this.sizeY / this.tank.getCapacity();
    }
}

