/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.api.world.IFeatureGenerator;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;

public abstract class FeatureBase
implements IFeatureGenerator {
    public final String name;
    public final GenRestriction biomeRestriction;
    public final GenRestriction dimensionRestriction;
    public final boolean regen;
    protected final Set<String> biomes = new THashSet();
    protected final Set<Integer> dimensions = new THashSet();

    public FeatureBase(String name, boolean regen) {
        this(name, GenRestriction.NONE, regen, GenRestriction.NONE);
    }

    public FeatureBase(String name, boolean regen, GenRestriction dimRes) {
        this(name, GenRestriction.NONE, regen, dimRes);
    }

    public FeatureBase(String name, GenRestriction biomeRes, boolean regen) {
        this(name, biomeRes, regen, GenRestriction.NONE);
    }

    public FeatureBase(String name, GenRestriction biomeRes, boolean regen, GenRestriction dimRes) {
        this.name = name;
        this.biomeRestriction = biomeRes;
        this.dimensionRestriction = dimRes;
        this.regen = regen;
    }

    public FeatureBase addBiome(String biomeName) {
        this.biomes.add(biomeName);
        return this;
    }

    public FeatureBase addDimension(int dimID) {
        this.dimensions.add(dimID);
        return this;
    }

    @Override
    public final String getFeatureName() {
        return this.name;
    }

    @Override
    public abstract boolean generateFeature(Random var1, int var2, int var3, World var4, boolean var5);

    public static enum GenRestriction {
        NONE,
        BLACKLIST,
        WHITELIST;

    }
}

