/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SecurityHelper {
    private SecurityHelper() {
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound tag, ISecurable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74757_a("Secure", true);
        tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
        tag.func_74778_a("Owner", tile.getOwnerName());
        return tag;
    }

    public static void addOwnerInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            if (!stack.field_77990_d.func_74764_b("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + stack.field_77990_d.func_74779_i("Owner"));
            }
        }
    }

    public static void addAccessInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            String accessString = "";
            switch (stack.field_77990_d.func_74771_c("Access")) {
                case 0: {
                    accessString = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    accessString = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    accessString = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + accessString);
        }
    }

    public static boolean isSecure(ItemStack stack) {
        return stack.field_77990_d == null ? false : stack.field_77990_d.func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            return stack;
        }
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("Secure", true);
        stack.field_77990_d.func_74774_a("Access", (byte)0);
        return stack;
    }

    public static boolean setAccess(ItemStack stack, ISecurable.AccessMode access) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.field_77990_d.func_74774_a("Access", (byte)access.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        return stack.field_77990_d == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[stack.field_77990_d.func_74771_c("Access")];
    }

    public static boolean setOwnerName(ItemStack stack, String name) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.field_77990_d.func_74778_a("Owner", name);
        return true;
    }

    public static String getOwnerName(ItemStack stack) {
        return stack.field_77990_d == null ? "[None]" : stack.field_77990_d.func_74779_i("Owner");
    }
}

