/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.transport.IItemDuct;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static ItemStack[] cloneInventory(ItemStack[] inventory) {
        ItemStack[] inventoryCopy = new ItemStack[inventory.length];
        for (int i = 0; i < inventory.length; ++i) {
            inventoryCopy[i] = inventory[i] == null ? null : inventory[i].func_77946_l();
        }
        return inventoryCopy;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        if (stack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i < inventory.length; ++i) {
            if (ItemHelper.itemsEqualForCrafting(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                int hold = inventory[i].func_77976_d() - inventory[i].field_77994_a;
                if (hold >= stack.field_77994_a) {
                    inventory[i].field_77994_a += stack.field_77994_a;
                    stack = null;
                    return true;
                }
                stack.field_77994_a -= hold;
                inventory[i].field_77994_a += hold;
                continue;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot <= -1) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, 0);
    }

    public static ItemStack extractItemStackFromInventory(IInventory inventory, int side) {
        ItemStack retStack = null;
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            for (int i = 0; i < slots.length && retStack == null; ++i) {
                if (sidedInv.func_70301_a(i) == null || !sidedInv.func_102008_b(i, sidedInv.func_70301_a(i), side)) continue;
                retStack = sidedInv.func_70301_a(i).func_77946_l();
                sidedInv.func_70299_a(i, null);
            }
        } else {
            for (int i = 0; i < inventory.func_70302_i_() && retStack == null; ++i) {
                if (inventory.func_70301_a(i) == null) continue;
                retStack = inventory.func_70301_a(i).func_77946_l();
                inventory.func_70299_a(i, null);
            }
        }
        if (retStack != null) {
            inventory.func_70296_d();
        }
        return retStack;
    }

    public static ItemStack insertItemStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null) {
            return null;
        }
        int stackSize = stack.field_77994_a;
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !ItemHelper.itemsEqualWithMetadata(stack, inventory.func_70301_a(slots[i]), true)) continue;
                stack = InventoryHelper.addToOccupiedInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || inventory.func_70301_a(slots[i]) != null) continue;
                stack = InventoryHelper.addToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                if (!ItemHelper.itemsEqualWithMetadata(stack, inventory.func_70301_a(i), true)) continue;
                stack = InventoryHelper.addToOccupiedInventorySlot(inventory, i, stack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                stack = InventoryHelper.addToEmptyInventorySlot(inventory, i, stack);
            }
        }
        if (stack == null || stack.field_77994_a != stackSize) {
            inventory.func_70296_d();
        }
        return stack;
    }

    public static ItemStack simulateInsertItemStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null) {
            return null;
        }
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !ItemHelper.itemsEqualWithMetadata(stack, inventory.func_70301_a(slots[i]), true)) continue;
                stack = InventoryHelper.simulateAddToOccupiedInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || inventory.func_70301_a(slots[i]) != null) continue;
                stack = InventoryHelper.simulateAddToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                if (!ItemHelper.itemsEqualWithMetadata(stack, inventory.func_70301_a(i), true)) continue;
                stack = InventoryHelper.simulateAddToOccupiedInventorySlot(inventory, i, stack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                stack = InventoryHelper.simulateAddToEmptyInventorySlot(inventory, i, stack);
            }
        }
        return stack;
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, ItemHelper.cloneStack(stack, Math.min(stack.field_77994_a, stackLimit)));
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack addToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        int stackLimit = Math.min(inventory.func_70297_j_(), stackInSlot.func_77976_d());
        if (stack.field_77994_a + stackInSlot.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, stackInSlot);
            return stack;
        }
        stackInSlot.field_77994_a += Math.min(stack.field_77994_a, stackLimit);
        inventory.func_70299_a(slot, stackInSlot);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack simulateAddToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack simulateAddToOccupiedInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        int stackLimit = Math.min(inventory.func_70297_j_(), stackInSlot.func_77976_d());
        if (stack.field_77994_a + stackInSlot.field_77994_a > stackLimit) {
            stack.field_77994_a -= stackLimit - stackInSlot.field_77994_a;
            return stack;
        }
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int length, boolean reverse) {
        return InventoryHelper.mergeItemStack(slots, stack, start, length, reverse, true);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int length, boolean r, boolean limit) {
        ItemStack existingStack;
        Slot slot;
        int i;
        int iterOrder;
        boolean successful = false;
        int n = iterOrder = !r ? 1 : -1;
        if (stack.func_77985_e()) {
            for (i = !r ? start : length - 1; stack.field_77994_a > 0 && (!r && i < length || r && i >= start); i += iterOrder) {
                slot = slots.get(i);
                existingStack = slot.func_75211_c();
                if (!slot.func_75214_a(stack) || existingStack == null || !existingStack.func_77973_b().equals(stack.func_77973_b()) || stack.func_77981_g() && stack.func_77960_j() != existingStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                int existingSize = existingStack.field_77994_a + stack.field_77994_a;
                int maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a());
                if (existingSize <= maxStack) {
                    stack.field_77994_a = 0;
                    existingStack.field_77994_a = existingSize;
                    slot.func_75218_e();
                    successful = true;
                    continue;
                }
                if (existingStack.field_77994_a >= maxStack) continue;
                stack.field_77994_a -= maxStack - existingStack.field_77994_a;
                existingStack.field_77994_a = maxStack;
                slot.func_75218_e();
                successful = true;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = i = !r ? start : length - 1;
            while (stack.field_77994_a > 0 && (!r && i < length || r && i >= start)) {
                slot = slots.get(i);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack == null) {
                    int maxStack = limit ? Math.min(stack.func_77976_d(), slot.func_75219_a()) : slot.func_75219_a();
                    existingStack = stack.func_77979_a(Math.min(stack.field_77994_a, maxStack));
                    slot.func_75215_d(existingStack);
                    slot.func_75218_e();
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public static ItemStack addToInsertion(Object tile, int side, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        stack = tile instanceof IInventory ? InventoryHelper.insertItemStackIntoInventory((IInventory)tile, stack, BlockHelper.SIDE_OPPOSITE[side]) : ((IItemDuct)tile).insertItem(ForgeDirection.VALID_DIRECTIONS[side ^ 1], stack);
        return stack;
    }

    public static boolean isInventory(TileEntity tile) {
        return tile instanceof IInventory;
    }

    public static boolean isInsertion(Object tile) {
        return tile instanceof IInventory || tile instanceof IItemDuct;
    }
}

