/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.lib.util.helpers.BlockHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyHelper {
    public final int RF_PER_MJ = 10;
    public final int RF_PER_EU = 4;

    private EnergyHelper() {
    }

    public static int extractEnergyFromHeldContainer(EntityPlayer player, int maxExtract, boolean simulate) {
        ItemStack container = player.func_71045_bC();
        return EnergyHelper.isEnergyContainerItem(container) ? ((IEnergyContainerItem)container.func_77973_b()).extractEnergy(container, maxExtract, simulate) : 0;
    }

    public static int insertEnergyIntoHeldContainer(EntityPlayer player, int maxReceive, boolean simulate) {
        ItemStack container = player.func_71045_bC();
        return EnergyHelper.isEnergyContainerItem(container) ? ((IEnergyContainerItem)container.func_77973_b()).receiveEnergy(container, maxReceive, simulate) : 0;
    }

    public static boolean isPlayerHoldingEnergyContainerItem(EntityPlayer player) {
        return EnergyHelper.isEnergyContainerItem(player.func_71045_bC());
    }

    public static boolean isEnergyContainerItem(ItemStack container) {
        return container != null && container.func_77973_b() instanceof IEnergyContainerItem;
    }

    public static ItemStack setDefaultEnergyTag(ItemStack container, int energy) {
        if (container.field_77990_d == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.field_77990_d.func_74768_a("Energy", energy);
        return container;
    }

    public static int extractEnergyFromAdjacentEnergyHandler(TileEntity tile, int side, int energy, boolean simulate) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return handler instanceof IEnergyHandler ? ((IEnergyHandler)handler).extractEnergy(ForgeDirection.VALID_DIRECTIONS[side ^ 1], energy, simulate) : 0;
    }

    public static int insertEnergyIntoAdjacentEnergyHandler(TileEntity tile, int side, int energy, boolean simulate) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return handler instanceof IEnergyHandler ? ((IEnergyHandler)handler).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[side ^ 1], energy, simulate) : 0;
    }

    public static boolean isAdjacentEnergyHandlerFromSide(TileEntity tile, int side) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return EnergyHelper.isEnergyHandlerFromSide(handler, ForgeDirection.VALID_DIRECTIONS[side ^ 1]);
    }

    public static boolean isEnergyHandlerFromSide(TileEntity tile, ForgeDirection from) {
        return tile instanceof IEnergyHandler ? ((IEnergyHandler)tile).canConnectEnergy(from) : false;
    }
}

