/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonManaged;
import org.lwjgl.opengl.GL11;

public abstract class ElementSlider
extends ElementBase {
    protected int _value;
    protected int _valueMax;
    protected int _sliderWidth;
    protected int _sliderHeight;
    protected boolean _isDragging;
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();

    protected ElementSlider(GuiBase containerScreen, int x, int y, int width, int height, int maxValue) {
        super(containerScreen, x, y, width, height);
        this._valueMax = maxValue;
    }

    public ElementSlider setColor(int backgroundColor, int borderColor) {
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        return this;
    }

    public ElementSlider setSliderSize(int width, int height) {
        this._sliderWidth = width;
        this._sliderHeight = height;
        return this;
    }

    public void setValue(int value) {
        if (value != this._value && value >= 0 && value <= this._valueMax) {
            this._value = value;
            this.onValueChanged(this._value);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.backgroundColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int sliderWidth = this._sliderWidth;
        int sliderHeight = this._sliderHeight;
        int sliderX = this.posX + this.getSliderX();
        int sliderY = this.posY + this.getSliderY();
        if (!this.isEnabled()) {
            this.gui.bindTexture(ElementButtonManaged.DISABLED);
        } else if (this.isHovering(mouseX, mouseY)) {
            this.gui.bindTexture(ElementButtonManaged.HOVER);
        } else {
            this.gui.bindTexture(ElementButtonManaged.ENABLED);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(sliderX, sliderY, 0, 0, sliderWidth / 2, sliderHeight / 2);
        this.drawTexturedModalRect(sliderX, sliderY + sliderHeight / 2, 0, 256 - sliderHeight / 2, sliderWidth / 2, sliderHeight / 2);
        this.drawTexturedModalRect(sliderX + sliderWidth / 2, sliderY, 256 - sliderWidth / 2, 0, sliderWidth / 2, sliderHeight / 2);
        this.drawTexturedModalRect(sliderX + sliderWidth / 2, sliderY + sliderHeight / 2, 256 - sliderWidth / 2, 256 - sliderHeight / 2, sliderWidth / 2, sliderHeight / 2);
    }

    protected boolean isHovering(int x, int y) {
        return this.intersectsWith(x, y);
    }

    public int getSliderX() {
        return 0;
    }

    public int getSliderY() {
        return 0;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this._isDragging = mouseButton == 0;
        return true;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        this._isDragging = false;
    }

    @Override
    public void update(int mouseX, int mouseY) {
        if (this._isDragging) {
            this.dragSlider(mouseX - this.posX, mouseY - this.posY);
        }
    }

    protected abstract void dragSlider(int var1, int var2);

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (movement > 0) {
            this.setValue(this._value - 1);
        } else if (movement < 0) {
            this.setValue(this._value + 1);
        }
        return true;
    }

    public abstract void onValueChanged(int var1);
}

