/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class WrapperChainedInventory
implements IInventory {
    int fullSize = 0;
    private List<IInventory> l;
    private HashMap<Integer, InvOffset> offsets;

    public WrapperChainedInventory(IInventory ... inventories) {
        this.setInventory(inventories);
    }

    public WrapperChainedInventory(List<IInventory> inventories) {
        this.setInventory(inventories);
    }

    public void cycleOrder() {
        if (this.l.size() > 1) {
            ArrayList<IInventory> newOrder = new ArrayList<IInventory>(this.l.size());
            newOrder.add(this.l.get(this.l.size() - 1));
            for (int x = 0; x < this.l.size() - 1; ++x) {
                newOrder.add(this.l.get(x));
            }
            this.setInventory(newOrder);
        }
    }

    public void calculateSizes() {
        this.offsets = new HashMap();
        int offset = 0;
        for (IInventory in : this.l) {
            InvOffset io = new InvOffset();
            io.offset = offset;
            io.size = in.func_70302_i_();
            io.i = in;
            for (int y = 0; y < io.size; ++y) {
                this.offsets.put(y + io.offset, io);
            }
            offset += io.size;
        }
        this.fullSize = offset;
    }

    public void setInventory(IInventory ... a) {
        this.l = ImmutableList.copyOf((Object[])a);
        this.calculateSizes();
    }

    public void setInventory(List<IInventory> a) {
        this.l = a;
        this.calculateSizes();
    }

    public IInventory getInv(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i;
        }
        return null;
    }

    public int getInvSlot(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return idx - io.offset;
        }
        return 0;
    }

    public int func_70302_i_() {
        return this.fullSize;
    }

    public ItemStack func_70301_a(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i.func_70301_a(idx - io.offset);
        }
        return null;
    }

    public ItemStack func_70298_a(int idx, int var2) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i.func_70298_a(idx - io.offset, var2);
        }
        return null;
    }

    public ItemStack func_70304_b(int idx) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i.func_70304_b(idx - io.offset);
        }
        return null;
    }

    public void func_70299_a(int idx, ItemStack var2) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            io.i.func_70299_a(idx - io.offset, var2);
        }
    }

    public String func_145825_b() {
        return "ChainedInv";
    }

    public int func_70297_j_() {
        int smallest = 64;
        for (IInventory i : this.l) {
            smallest = Math.min(smallest, i.func_70297_j_());
        }
        return smallest;
    }

    public void func_70296_d() {
        for (IInventory i : this.l) {
            i.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int idx, ItemStack itemstack) {
        InvOffset io = this.offsets.get(idx);
        if (io != null) {
            return io.i.func_94041_b(idx - io.offset, itemstack);
        }
        return false;
    }

    static class InvOffset {
        int offset;
        int size;
        IInventory i;

        InvOffset() {
        }
    }
}

