/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AppEng;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IInvTweaks;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Comparator;

public class ItemSorters {
    public static SortDir Direction = SortDir.ASCENDING;
    private static IInvTweaks api;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_NAME;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_MOD;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_SIZE;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_INV_TWEAKS;

    public static void init() {
        if (api != null) {
            return;
        }
        api = AppEng.instance.isIntegrationEnabled(IntegrationType.InvTweaks) ? (IInvTweaks)AppEng.instance.getIntegration(IntegrationType.InvTweaks) : null;
    }

    public static int compareInt(int a, int b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareLong(long a, long b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static int compareDouble(double a, double b) {
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    static {
        CONFIG_BASED_SORT_BY_NAME = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                if (Direction == SortDir.ASCENDING) {
                    return Platform.getItemDisplayName(o1).compareToIgnoreCase(Platform.getItemDisplayName(o2));
                }
                return Platform.getItemDisplayName(o2).compareToIgnoreCase(Platform.getItemDisplayName(o1));
            }
        };
        CONFIG_BASED_SORT_BY_MOD = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                AEItemStack op1 = (AEItemStack)o1;
                AEItemStack op2 = (AEItemStack)o2;
                if (Direction == SortDir.ASCENDING) {
                    return this.secondarySort(op2.getModID().compareToIgnoreCase(op1.getModID()), o1, o2);
                }
                return this.secondarySort(op1.getModID().compareToIgnoreCase(op2.getModID()), o2, o1);
            }

            private int secondarySort(int compareToIgnoreCase, IAEItemStack o1, IAEItemStack o2) {
                if (compareToIgnoreCase == 0) {
                    return Platform.getItemDisplayName(o2).compareToIgnoreCase(Platform.getItemDisplayName(o1));
                }
                return compareToIgnoreCase;
            }
        };
        CONFIG_BASED_SORT_BY_SIZE = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                if (Direction == SortDir.ASCENDING) {
                    return ItemSorters.compareLong(o2.getStackSize(), o1.getStackSize());
                }
                return ItemSorters.compareLong(o1.getStackSize(), o2.getStackSize());
            }
        };
        CONFIG_BASED_SORT_BY_INV_TWEAKS = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                if (api == null) {
                    return CONFIG_BASED_SORT_BY_NAME.compare(o1, o2);
                }
                int cmp = api.compareItems(o1.getItemStack(), o2.getItemStack());
                if (Direction == SortDir.ASCENDING) {
                    return cmp;
                }
                return -cmp;
            }
        };
    }
}

