/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.FuzzyMode;
import appeng.core.AppEng;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBetterStorage;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorISpecialInventory;
import appeng.util.inv.AdaptorList;
import appeng.util.inv.AdaptorPlayerInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.inv.WrapperMCISidedInventory;
import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class InventoryAdaptor
implements Iterable<ItemSlot> {
    private static boolean canBeSpecial = true;

    public abstract ItemStack removeItems(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack simulateRemove(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack removeSimilarItems(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack simulateSimilarRemove(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack addItems(ItemStack var1);

    public abstract ItemStack simulateAdd(ItemStack var1);

    public abstract boolean containsItems();

    public static InventoryAdaptor getAdaptor(Object te, ForgeDirection d) {
        IInventory i;
        if (te == null) {
            return null;
        }
        IBetterStorage bs = (IBetterStorage)(AppEng.instance.isIntegrationEnabled(IntegrationType.BetterStorage) ? AppEng.instance.getIntegration(IntegrationType.BetterStorage) : null);
        if (te instanceof EntityPlayer) {
            return new AdaptorIInventory(new AdaptorPlayerInventory((IInventory)((EntityPlayer)te).field_71071_by, false));
        }
        if (te instanceof ArrayList) {
            return new AdaptorList((ArrayList)te);
        }
        if (bs != null && bs.isStorageCrate(te)) {
            return bs.getAdaptor(te, d);
        }
        if (te instanceof TileEntityChest) {
            return new AdaptorIInventory(Platform.GetChestInv(te));
        }
        if (InventoryAdaptor.isSpecialInventory(te)) {
            return new AdaptorISpecialInventory((ISpecialInventory)te, d);
        }
        if (te instanceof ISidedInventory) {
            ISidedInventory si = (ISidedInventory)te;
            int[] slots = si.func_94128_d(d.ordinal());
            if (si.func_70302_i_() > 0 && slots != null && slots.length > 0) {
                return new AdaptorIInventory(new WrapperMCISidedInventory(si, d));
            }
        } else if (te instanceof IInventory && (i = (IInventory)te).func_70302_i_() > 0) {
            return new AdaptorIInventory(i);
        }
        return null;
    }

    private static boolean isSpecialInventory(Object a) {
        if (canBeSpecial) {
            try {
                return a instanceof ISpecialInventory;
            }
            catch (Throwable e) {
                canBeSpecial = false;
            }
        }
        return false;
    }
}

