/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIOPort
extends AENetworkInvTile
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable {
    final ConfigManager cm = new ConfigManager(this);
    final int[] input = new int[]{0, 1, 2, 3, 4, 5};
    final int[] output = new int[]{6, 7, 8, 9, 10, 11};
    final int[] outputSlots = new int[]{6, 7, 8, 9, 10, 11};
    final AppEngInternalInventory cells = new AppEngInternalInventory(this, 12);
    final UpgradeInventory upgrades;
    final BaseActionSource mySrc;
    YesNo lastRedstoneState;
    ItemStack currentCell;
    IMEInventory<IAEFluidStack> cachedFluid;
    IMEInventory<IAEItemStack> cachedItem;

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileIOPort(NBTTagCompound data) {
        this.cm.writeToNBT(data);
        this.cells.writeToNBT(data, "cells");
        this.upgrades.writeToNBT(data, "upgrades");
        data.func_74768_a("lastRedstoneState", this.lastRedstoneState.ordinal());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileIOPort(NBTTagCompound data) {
        this.cm.readFromNBT(data);
        this.cells.readFromNBT(data, "cells");
        this.upgrades.readFromNBT(data, "upgrades");
        if (data.func_74764_b("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.func_74762_e("lastRedstoneState")];
        }
    }

    public TileIOPort() {
        this.upgrades = new UpgradeInventory(AEApi.instance().blocks().blockIOPort.block(), this, 3);
        this.mySrc = new MachineSource(this);
        this.lastRedstoneState = YesNo.UNDECIDED;
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.cm.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.cm.registerSetting(Settings.FULLNESS_MODE, FullnessMode.EMPTY);
        this.cm.registerSetting(Settings.OPERATION_MODE, OperationMode.EMPTY);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.cells;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.cells == inv) {
            this.updateTask();
        }
    }

    private void updateTask() {
        try {
            if (this.hasWork()) {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            } else {
                this.gridProxy.getTick().sleepDevice(this.gridProxy.getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            this.updateTask();
        }
    }

    public boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private boolean isEnabled() {
        if (this.getInstalledUpgrades(Upgrades.REDSTONE) == 0) {
            return true;
        }
        RedstoneMode rs = (RedstoneMode)this.cm.getSetting(Settings.REDSTONE_CONTROLLED);
        if (rs == RedstoneMode.HIGH_SIGNAL) {
            return this.getRedstoneState();
        }
        return !this.getRedstoneState();
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection d) {
        if (d == ForgeDirection.UP || d == ForgeDirection.DOWN) {
            return this.input;
        }
        return this.output;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals("cells")) {
            return this.cells;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateTask();
    }

    boolean hasWork() {
        if (this.isEnabled()) {
            for (int x = 0; x < 6; ++x) {
                if (this.cells.func_70301_a(x) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.IOPort.min, TickRates.IOPort.max, this.hasWork(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (!this.gridProxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        long ItemsToMove = 256L;
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 1: {
                ItemsToMove *= 2L;
                break;
            }
            case 2: {
                ItemsToMove *= 4L;
                break;
            }
            case 3: {
                ItemsToMove *= 8L;
            }
        }
        try {
            IMEMonitor<IAEItemStack> itemNet = this.gridProxy.getStorage().getItemInventory();
            IMEMonitor<IAEFluidStack> fluidNet = this.gridProxy.getStorage().getFluidInventory();
            IEnergyGrid energy = this.gridProxy.getEnergy();
            for (int x = 0; x < 6; ++x) {
                ItemStack is = this.cells.func_70301_a(x);
                if (is == null) continue;
                if (ItemsToMove > 0L) {
                    IMEInventory itemInv = this.getInv(is, StorageChannel.ITEMS);
                    IMEInventory fluidInv = this.getInv(is, StorageChannel.FLUIDS);
                    if (this.cm.getSetting(Settings.OPERATION_MODE) == OperationMode.EMPTY) {
                        if (itemInv != null) {
                            ItemsToMove = this.transferContents(energy, itemInv, itemNet, ItemsToMove, StorageChannel.ITEMS);
                        }
                        if (fluidInv != null) {
                            ItemsToMove = this.transferContents(energy, fluidInv, fluidNet, ItemsToMove, StorageChannel.FLUIDS);
                        }
                    } else {
                        if (itemInv != null) {
                            ItemsToMove = this.transferContents(energy, itemNet, itemInv, ItemsToMove, StorageChannel.ITEMS);
                        }
                        if (fluidInv != null) {
                            ItemsToMove = this.transferContents(energy, fluidNet, fluidInv, ItemsToMove, StorageChannel.FLUIDS);
                        }
                    }
                    if (ItemsToMove > 0L && this.shouldMove(itemInv, fluidInv) && !this.moveSlot(x)) {
                        return TickRateModulation.IDLE;
                    }
                    return TickRateModulation.URGENT;
                }
                return TickRateModulation.URGENT;
            }
        }
        catch (GridAccessException e) {
            return TickRateModulation.IDLE;
        }
        return TickRateModulation.SLEEP;
    }

    private boolean shouldMove(IMEInventory<IAEItemStack> itemInv, IMEInventory<IAEFluidStack> fluidInv) {
        FullnessMode fm = (FullnessMode)this.cm.getSetting(Settings.FULLNESS_MODE);
        if (itemInv != null && fluidInv != null) {
            return this.matches(fm, itemInv) && this.matches(fm, fluidInv);
        }
        if (itemInv != null) {
            return this.matches(fm, itemInv);
        }
        if (fluidInv != null) {
            return this.matches(fm, fluidInv);
        }
        return true;
    }

    private boolean matches(FullnessMode fm, IMEInventory src) {
        if (fm == FullnessMode.HALF) {
            return true;
        }
        IItemList<Object> myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        if (fm == FullnessMode.EMPTY) {
            return myList.isEmpty();
        }
        Object test = myList.getFirstItem();
        if (test != null) {
            test.setStackSize(1L);
            return src.injectItems(test, Actionable.SIMULATE, this.mySrc) != null;
        }
        return false;
    }

    private IMEInventory getInv(ItemStack is, StorageChannel chan) {
        if (this.currentCell != is) {
            this.currentCell = is;
            this.cachedFluid = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.FLUIDS);
            this.cachedItem = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        }
        if (StorageChannel.ITEMS == chan) {
            return this.cachedItem;
        }
        return this.cachedFluid;
    }

    private long transferContents(IEnergySource energy, IMEInventory src, IMEInventory destination, long itemsToMove, StorageChannel chan) {
        boolean didStuff;
        IItemList<Object> myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        block0: do {
            didStuff = false;
            for (IAEStack iAEStack : myList) {
                long totalStackSize = iAEStack.getStackSize();
                if (totalStackSize <= 0L) continue;
                IAEStack stack = destination.injectItems(iAEStack, Actionable.SIMULATE, this.mySrc);
                long possible = 0L;
                possible = stack == null ? totalStackSize : totalStackSize - stack.getStackSize();
                if (possible <= 0L) continue;
                possible = Math.min(possible, itemsToMove);
                iAEStack.setStackSize(possible);
                IAEStack extracted = src.extractItems(iAEStack, Actionable.MODULATE, this.mySrc);
                if (extracted == null) continue;
                possible = extracted.getStackSize();
                IAEStack failed = Platform.poweredInsert(energy, destination, extracted, this.mySrc);
                if (failed != null) {
                    possible -= failed.getStackSize();
                    src.injectItems(failed, Actionable.MODULATE, this.mySrc);
                }
                if (possible <= 0L) continue block0;
                itemsToMove -= possible;
                didStuff = true;
                continue block0;
            }
        } while (itemsToMove > 0L && didStuff);
        return itemsToMove;
    }

    private boolean moveSlot(int x) {
        WrapperInventoryRange wir = new WrapperInventoryRange((IInventory)this, this.outputSlots, true);
        ItemStack result = InventoryAdaptor.getAdaptor(wir, ForgeDirection.UNKNOWN).addItems(this.func_70301_a(x));
        if (result == null) {
            this.func_70299_a(x, null);
            return true;
        }
        return false;
    }

    @Override
    public void getDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.func_70302_i_(); ++upgradeIndex) {
            ItemStack stackInSlot = this.upgrades.func_70301_a(upgradeIndex);
            if (stackInSlot == null) continue;
            drops.add(stackInSlot);
        }
    }
}

