/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQuantumBridge
extends AENetworkInvTile
implements IAEMultiBlock {
    private static final ItemStack RING_STACK = AEApi.instance().blocks().blockQuantumRing != null ? AEApi.instance().blocks().blockQuantumRing.stack(1) : null;
    final int[] sidesRing = new int[0];
    final int[] sidesLink = new int[]{0};
    final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1);
    public final byte corner = (byte)16;
    final byte hasSingularity = (byte)32;
    final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    byte constructed = (byte)-1;
    QuantumCluster cluster;
    public boolean bridgePowered;
    private boolean updateStatus = false;

    @TileEvent(value=TileEventType.TICK)
    public void onTickEvent() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onNetworkWriteEvent(ByteBuf data) {
        int out = this.constructed;
        if (this.func_70301_a(0) != null && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.gridProxy.isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean onNetworkReadEvent(ByteBuf data) {
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        this.bridgePowered = (this.constructed | this.powered) == this.powered;
        return this.constructed != oldValue;
    }

    public TileQuantumBridge() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.gridProxy.setFlags(GridFlags.DENSE_CAPACITY);
        this.gridProxy.setIdlePowerUsage(22.0);
        this.internalInventory.setMaxStackSize(1);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.internalInventory;
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        if (this.isCenter()) {
            return this.sidesLink;
        }
        return this.sidesRing;
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.updateStatus = false;
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == AEApi.instance().blocks().blockQuantumRing.block()) {
            this.gridProxy.setVisualRepresentation(RING_STACK);
        }
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                this.gridProxy.setValidSides(this.getConnections());
            } else {
                this.gridProxy.setValidSides(EnumSet.allOf(ForgeDirection.class));
            }
        }
    }

    public long getQEFrequency() {
        NBTTagCompound c;
        ItemStack is = this.internalInventory.func_70301_a(0);
        if (is != null && (c = is.func_77978_p()) != null) {
            return c.func_74763_f("freq");
        }
        return 0L;
    }

    public boolean isCenter() {
        return this.func_145838_q() == AEApi.instance().blocks().blockQuantumLink.block();
    }

    public boolean isCorner() {
        return (this.constructed & this.corner) == this.corner && this.constructed != -1;
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        try {
            return this.gridProxy.getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public void neighborUpdate() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    public EnumSet<ForgeDirection> getConnections() {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (!(te instanceof TileQuantumBridge)) continue;
            set.add(d);
        }
        return set;
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }
}

