/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.core.AppEng;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IIC2;
import appeng.tile.powersink.MinecraftJoules6;
import appeng.transformer.annotations.integration;
import appeng.util.Platform;
import ic2.api.energy.tile.IEnergySink;
import java.util.EnumSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@integration.Interface(iname="IC2", iface="ic2.api.energy.tile.IEnergySink")
public abstract class IC2
extends MinecraftJoules6
implements IEnergySink {
    boolean isInIC2 = false;

    public final boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getPowerSides().contains(direction);
    }

    public final double getDemandedEnergy() {
        return this.getExternalPowerDemand(PowerUnits.EU, Double.MAX_VALUE);
    }

    public final double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double overflow = PowerUnits.EU.convertTo(PowerUnits.AE, this.injectExternalPower(PowerUnits.EU, amount));
        this.internalCurrentPower += overflow;
        return 0.0;
    }

    public final int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removeFromENet();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.removeFromENet();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.addToENet();
    }

    @Override
    protected void setPowerSides(EnumSet<ForgeDirection> sides) {
        super.setPowerSides(sides);
        this.removeFromENet();
        this.addToENet();
    }

    private void addToENet() {
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.IC2)) {
            IIC2 ic2Integration = (IIC2)AppEng.instance.getIntegration(IntegrationType.IC2);
            if (!this.isInIC2 && Platform.isServer() && ic2Integration != null) {
                ic2Integration.addToEnergyNet(this);
                this.isInIC2 = true;
            }
        }
    }

    private void removeFromENet() {
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.IC2)) {
            IIC2 ic2Integration = (IIC2)AppEng.instance.getIntegration(IntegrationType.IC2);
            if (this.isInIC2 && Platform.isServer() && ic2Integration != null) {
                ic2Integration.removeFromEnergyNet(this);
                this.isInIC2 = false;
            }
        }
    }
}

