/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyAcceptor
extends AENetworkPowerTile {
    static final AppEngInternalInventory INTERNAL_INVENTORY = new AppEngInternalInventory(null, 0);
    final int[] sides = new int[0];

    public TileEnergyAcceptor() {
        this.gridProxy.setIdlePowerUsage(0.0);
        this.internalMaxPower = 0.0;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @Override
    public void readFromNBT_AENetwork(NBTTagCompound data) {
    }

    @Override
    public void writeToNBT_AENetwork(NBTTagCompound data) {
    }

    @Override
    protected double getFunnelPowerDemand(double maxRequired) {
        try {
            IEnergyGrid grid = this.gridProxy.getEnergy();
            return grid.getEnergyDemand(maxRequired);
        }
        catch (GridAccessException e) {
            return this.internalMaxPower;
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double newPower, Actionable mode) {
        try {
            IEnergyGrid grid = this.gridProxy.getEnergy();
            double leftOver = grid.injectPower(newPower, mode);
            if (mode == Actionable.SIMULATE) {
                return leftOver;
            }
            return 0.0;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(newPower, mode);
        }
    }

    @Override
    public IInventory getInternalInventory() {
        return INTERNAL_INVENTORY;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }
}

