/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IPart;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.networking.BlockCableBus;
import appeng.core.AppEng;
import appeng.helpers.AEMultiTile;
import appeng.helpers.ICustomCollision;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IImmibisMicroblocks;
import appeng.parts.CableBusContainer;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCableBus
extends AEBaseTile
implements AEMultiTile,
ICustomCollision {
    public CableBusContainer cb = new CableBusContainer(this);
    private int oldLV = -1;
    boolean ImmibisMicroblocks_TransformableTileEntityMarker = true;

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCableBus(NBTTagCompound data) {
        this.cb.readFromNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCableBus(NBTTagCompound data) {
        this.cb.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileCableBus(ByteBuf data) throws IOException {
        boolean ret = this.cb.readFromStream(data);
        int newLV = this.cb.getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.updateTileSetting();
        return ret;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileCableBus(ByteBuf data) throws IOException {
        this.cb.writeToStream(data);
    }

    @Override
    public boolean isInWorld() {
        return this.cb.isInWorld();
    }

    protected void updateTileSetting() {
        if (this.cb.requiresDynamicRender) {
            try {
                TileCableBus tcb = (TileCableBus)BlockCableBus.tesrTile.newInstance();
                tcb.copyFrom(this);
                this.func_145831_w().func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)tcb);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void copyFrom(TileCableBus oldTile) {
        CableBusContainer tmpCB = this.cb;
        this.cb = oldTile.cb;
        this.oldLV = oldTile.oldLV;
        oldTile.cb = tmpCB;
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.cb.isEmpty()) {
            if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this) {
                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
            }
        } else {
            this.cb.addToWorld();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.cb.removeFromWorld();
    }

    public void func_145829_t() {
        super.func_145829_t();
        TickHandler.INSTANCE.addInit(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.cb.removeFromWorld();
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public double func_145833_n() {
        return 900.0;
    }

    public void getDrops(World w, int x, int y, int z, ArrayList drops) {
        this.cb.getDrops(drops);
    }

    @Override
    public void getNoDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        this.cb.getNoDrops(drops);
    }

    @Override
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.cb.getGridNode(dir);
    }

    @Override
    public boolean canAddPart(ItemStack is, ForgeDirection side) {
        return this.cb.canAddPart(is, side);
    }

    @Override
    public ForgeDirection addPart(ItemStack is, ForgeDirection side, EntityPlayer player) {
        return this.cb.addPart(is, side, player);
    }

    @Override
    public void removePart(ForgeDirection side, boolean suppressUpdate) {
        this.cb.removePart(side, suppressUpdate);
    }

    @Override
    public IPart getPart(ForgeDirection side) {
        return this.cb.getPart(side);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean visual) {
        return this.cb.getSelectedBoundingBoxesFromPool(false, true, e, visual);
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        for (AxisAlignedBB bx : this.getSelectedBoundingBoxesFromPool(w, x, y, z, e, false)) {
            out.add(AxisAlignedBB.func_72330_a((double)bx.field_72340_a, (double)bx.field_72338_b, (double)bx.field_72339_c, (double)bx.field_72336_d, (double)bx.field_72337_e, (double)bx.field_72334_f));
        }
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection side) {
        return this.cb.getCableConnectionType(side);
    }

    @Override
    public AEColor getColor() {
        return this.cb.getColor();
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.cb.getFacadeContainer();
    }

    @Override
    public void clearContainer() {
        this.cb = new CableBusContainer(this);
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        return !this.ImmibisMicroblocks_isSideOpen(side.ordinal());
    }

    @Override
    public void markForUpdate() {
        if (this.field_145850_b == null) {
            return;
        }
        int newLV = this.cb.getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.markForUpdate();
    }

    @Override
    public SelectedPart selectPart(Vec3 pos) {
        return this.cb.selectPart(pos);
    }

    @Override
    public void partChanged() {
        this.notifyNeighbors();
    }

    @Override
    public void notifyNeighbors() {
        if (this.field_145850_b != null && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void markForSave() {
        super.func_70296_d();
    }

    @Override
    public boolean hasRedstone(ForgeDirection side) {
        return this.cb.hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        return this.cb.isEmpty();
    }

    @Override
    public boolean requiresTESR() {
        return this.cb.requiresDynamicRender;
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.cb.getLayerFlags();
    }

    @Override
    public void cleanup() {
        IImmibisMicroblocks imb;
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.ImmibisMicroblocks) && (imb = (IImmibisMicroblocks)AppEng.instance.getIntegration(IntegrationType.ImmibisMicroblocks)) != null && imb.leaveParts(this)) {
            return;
        }
        this.func_145831_w().func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Platform.AIR);
    }

    public boolean ImmibisMicroblocks_isSideOpen(int side) {
        return true;
    }

    public void ImmibisMicroblocks_onMicroblocksChanged() {
        this.cb.updateConnections();
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor colour, EntityPlayer who) {
        return this.cb.recolourBlock(side, colour, who);
    }
}

