/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQuartzGrowthAccelerator
extends AENetworkTile
implements IPowerChannelState,
ICrystalGrowthAccelerator {
    public boolean hasPower = false;

    @MENetworkEventSubscribe
    public void onPower(MENetworkPowerStatusChange ch) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileQuartzGrowthAccelerator(ByteBuf data) {
        boolean hadPower = this.hasPower;
        this.hasPower = data.readBoolean();
        return this.hasPower != hadPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileQuartzGrowthAccelerator(ByteBuf data) {
        try {
            data.writeBoolean(this.gridProxy.getEnergy().isNetworkPowered());
        }
        catch (GridAccessException e) {
            data.writeBoolean(false);
        }
    }

    public TileQuartzGrowthAccelerator() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.gridProxy.setFlags(new GridFlags[0]);
        this.gridProxy.setIdlePowerUsage(8.0);
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.gridProxy.setValidSides(EnumSet.of(this.getUp(), this.getUp().getOpposite()));
    }

    @Override
    public boolean isPowered() {
        if (Platform.isServer()) {
            try {
                return this.gridProxy.getEnergy().isNetworkPowered();
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return this.hasPower;
    }

    @Override
    public boolean isActive() {
        return this.isPowered();
    }
}

