/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.UpgradeInventory;
import appeng.recipes.handlers.Inscribe;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileInscriber
extends AENetworkPowerTile
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    final int[] top = new int[]{0};
    final int[] bottom = new int[]{1};
    final int[] sides = new int[]{2, 3};
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 4);
    public final int maxProcessingTime = 100;
    public int processingTime = 0;
    public boolean smash;
    public int finalStep;
    public long clientStart;
    static final ItemStack STACK_INSCRIBER = AEApi.instance().blocks().blockInscriber.stack(1);
    private final IConfigManager settings = new ConfigManager(this);
    private final UpgradeInventory upgrades = new UpgradeInventory(STACK_INSCRIBER, this, this.getUpgradeSlots());

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileInscriber(NBTTagCompound data) {
        this.inv.writeToNBT(data, "inscriberInv");
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileInscriber(NBTTagCompound data) {
        this.inv.readFromNBT(data, "inscriberInv");
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileInscriber(ByteBuf data) throws IOException {
        boolean newSmash;
        byte slot = data.readByte();
        boolean oldSmash = this.smash;
        boolean bl = newSmash = (slot & 0x40) == 64;
        if (oldSmash != newSmash && newSmash) {
            this.smash = true;
            this.clientStart = System.currentTimeMillis();
        }
        for (int num = 0; num < this.inv.func_70302_i_(); ++num) {
            if ((slot & 1 << num) > 0) {
                this.inv.func_70299_a(num, AEItemStack.loadItemStackFromPacket(data).getItemStack());
                continue;
            }
            this.inv.func_70299_a(num, null);
        }
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileInscriber(ByteBuf data) throws IOException {
        int num;
        int slot = this.smash ? 64 : 0;
        for (num = 0; num < this.inv.func_70302_i_(); ++num) {
            if (this.inv.func_70301_a(num) == null) continue;
            slot |= 1 << num;
        }
        data.writeByte(slot);
        for (num = 0; num < this.inv.func_70302_i_(); ++num) {
            if ((slot & 1 << num) <= 0) continue;
            AEItemStack st = AEItemStack.create(this.inv.func_70301_a(num));
            st.writeToPacket(data);
        }
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    public TileInscriber() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.internalMaxPower = 1500.0;
        this.gridProxy.setIdlePowerUsage(0.0);
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.gridProxy.setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        this.setPowerSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection d) {
        if (d == ForgeDirection.UP) {
            return this.top;
        }
        if (d == ForgeDirection.DOWN) {
            return this.bottom;
        }
        return this.sides;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.smash) {
            return false;
        }
        if (i == 0 || i == 1) {
            if (AEApi.instance().materials().materialNamePress.sameAsStack(itemstack)) {
                return true;
            }
            for (ItemStack s : Inscribe.PLATES) {
                if (!Platform.isSameItemPrecise(s, itemstack)) continue;
                return true;
            }
        }
        return i == 2;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (this.smash) {
            return false;
        }
        return i == 0 || i == 1 || i == 3;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            if (mc != InvOperation.markDirty) {
                if (slot != 3) {
                    this.processingTime = 0;
                }
                if (!this.smash) {
                    this.markForUpdate();
                }
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
    }

    public Inscribe.InscriberRecipe getTask() {
        ItemStack PlateA = this.func_70301_a(0);
        ItemStack PlateB = this.func_70301_a(1);
        ItemStack renamedItem = this.func_70301_a(2);
        if (PlateA != null && PlateA.field_77994_a > 1) {
            return null;
        }
        if (PlateB != null && PlateB.field_77994_a > 1) {
            return null;
        }
        if (renamedItem != null && renamedItem.field_77994_a > 1) {
            return null;
        }
        boolean isNameA = AEApi.instance().materials().materialNamePress.sameAsStack(PlateA);
        boolean isNameB = AEApi.instance().materials().materialNamePress.sameAsStack(PlateB);
        if ((isNameA || isNameB) && (isNameA || PlateA == null) && (isNameB || PlateB == null) && renamedItem != null) {
            NBTTagCompound tag;
            String name = "";
            if (PlateA != null) {
                tag = Platform.openNbtData(PlateA);
                name = name + tag.func_74779_i("InscribeName");
            }
            if (PlateB != null) {
                tag = Platform.openNbtData(PlateB);
                if (name.length() > 0) {
                    name = name + " ";
                }
                name = name + tag.func_74779_i("InscribeName");
            }
            ItemStack startingItem = renamedItem.func_77946_l();
            renamedItem = renamedItem.func_77946_l();
            NBTTagCompound tag2 = Platform.openNbtData(renamedItem);
            NBTTagCompound display = tag2.func_74775_l("display");
            tag2.func_74782_a("display", (NBTBase)display);
            if (name.length() > 0) {
                display.func_74778_a("Name", name);
            } else {
                display.func_82580_o("Name");
            }
            return new Inscribe.InscriberRecipe(new ItemStack[]{startingItem}, PlateA, PlateB, renamedItem, false);
        }
        for (Inscribe.InscriberRecipe i : Inscribe.RECIPES) {
            boolean matchB;
            boolean matchA;
            boolean bl = PlateA == null && i.plateA == null || Platform.isSameItemPrecise(PlateA, i.plateA) && (PlateB == null && i.plateB == null) | Platform.isSameItemPrecise(PlateB, i.plateB) ? true : (matchA = false);
            boolean bl2 = PlateB == null && i.plateA == null || Platform.isSameItemPrecise(PlateB, i.plateA) && (PlateA == null && i.plateB == null) | Platform.isSameItemPrecise(PlateA, i.plateB) ? true : (matchB = false);
            if (!matchA && !matchB) continue;
            for (ItemStack option : i.imprintable) {
                if (!Platform.isSameItemPrecise(option, this.func_70301_a(2))) continue;
                return i;
            }
        }
        return null;
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.processingTime = 0;
        return this.smash;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber.min, TickRates.Inscriber.max, !this.hasWork(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.smash) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                Inscribe.InscriberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack is = out.output.func_77946_l();
                    InventoryAdaptor ad = InventoryAdaptor.getAdaptor(new WrapperInventoryRange(this.inv, 3, 1, true), ForgeDirection.UNKNOWN);
                    if (ad.addItems(is) == null) {
                        this.processingTime = 0;
                        if (out.usePlates) {
                            this.func_70299_a(0, null);
                            this.func_70299_a(1, null);
                        }
                        this.func_70299_a(2, null);
                    }
                }
                this.func_70296_d();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.smash = false;
                this.markForUpdate();
            }
        } else {
            try {
                IEnergyGrid eg = this.gridProxy.getEnergy();
                IEnergySource src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.processingTime = this.processingTime == 0 ? (this.processingTime += speedFactor) : (this.processingTime += TicksSinceLastCall * speedFactor);
                }
            }
            catch (GridAccessException e) {
                // empty catch block
            }
            if (this.processingTime > this.maxProcessingTime) {
                this.processingTime = this.maxProcessingTime;
                Inscribe.InscriberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack is = out.output.func_77946_l();
                    InventoryAdaptor ad = InventoryAdaptor.getAdaptor(new WrapperInventoryRange(this.inv, 3, 1, true), ForgeDirection.UNKNOWN);
                    if (ad.simulateAdd(is) == null) {
                        this.smash = true;
                        this.finalStep = 0;
                        this.markForUpdate();
                    }
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.inv;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    protected int getUpgradeSlots() {
        return 3;
    }

    @Override
    public void getDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (int h = 0; h < this.upgrades.func_70302_i_(); ++h) {
            ItemStack is = this.upgrades.func_70301_a(h);
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }
}

