/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCrank
extends AEBaseTile
implements ICustomCollision {
    final int ticksPerRotation = 18;
    public float visibleRotation = 0.0f;
    public int charge = 0;
    public int hits = 0;
    public int rotation = 0;

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileCrank() {
        if (this.rotation > 0) {
            this.visibleRotation -= (float)(360 / this.ticksPerRotation);
            ++this.charge;
            if (this.charge >= this.ticksPerRotation) {
                this.charge -= this.ticksPerRotation;
                ICrankable g = this.getGrinder();
                if (g != null) {
                    g.applyTurn();
                }
            }
            --this.rotation;
        }
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileCrank(ByteBuf data) {
        this.rotation = data.readInt();
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileCrank(ByteBuf data) {
        data.writeInt(this.rotation);
    }

    public ICrankable getGrinder() {
        if (Platform.isClient()) {
            return null;
        }
        ForgeDirection grinder = this.getUp().getOpposite();
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + grinder.offsetX, this.field_145848_d + grinder.offsetY, this.field_145849_e + grinder.offsetZ);
        if (te instanceof ICrankable) {
            return (ICrankable)te;
        }
        return null;
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.func_145838_q().func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Platform.AIR);
    }

    public boolean power() {
        ICrankable g;
        if (Platform.isClient()) {
            return false;
        }
        if (this.rotation < 3 && (g = this.getGrinder()) != null) {
            if (g.canTurn()) {
                this.hits = 0;
                this.rotation += this.ticksPerRotation;
                this.markForUpdate();
                return true;
            }
            ++this.hits;
            if (this.hits > 10) {
                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            }
        }
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        double xOff = -0.15 * (double)this.getUp().offsetX;
        double yOff = -0.15 * (double)this.getUp().offsetY;
        double zOff = -0.15 * (double)this.getUp().offsetZ;
        return Collections.singletonList(AxisAlignedBB.func_72330_a((double)(xOff + 0.15), (double)(yOff + 0.15), (double)(zOff + 0.15), (double)(xOff + 0.85), (double)(yOff + 0.85), (double)(zOff + 0.85)));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        double xOff = -0.15 * (double)this.getUp().offsetX;
        double yOff = -0.15 * (double)this.getUp().offsetY;
        double zOff = -0.15 * (double)this.getUp().offsetZ;
        out.add(AxisAlignedBB.func_72330_a((double)(xOff + 0.15), (double)(yOff + 0.15), (double)(zOff + 0.15), (double)(xOff + 0.85), (double)(yOff + 0.85), (double)(zOff + 0.85)));
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }
}

