/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile;

import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.util.ICommonTile;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.IOrientable;
import appeng.core.AELog;
import appeng.core.features.ItemStackSrc;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.tile.TileEvent;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AEBaseTile
extends TileEntity
implements IOrientable,
ICommonTile,
ICustomNameObject {
    private static final HashMap<Class, EnumMap<TileEventType, List<AETileEventHandler>>> HANDLERS = new HashMap();
    private static final HashMap<Class, ItemStackSrc> ITEM_STACKS = new HashMap();
    private ForgeDirection forward = ForgeDirection.UNKNOWN;
    private ForgeDirection up = ForgeDirection.UNKNOWN;
    public static final ThreadLocal<WeakReference<AEBaseTile>> DROP_NO_ITEMS = new ThreadLocal();
    public int renderFragment = 0;
    public String customName;

    public void disableDrops() {
        DROP_NO_ITEMS.set(new WeakReference<AEBaseTile>(this));
    }

    public boolean dropItems() {
        WeakReference<AEBaseTile> what = DROP_NO_ITEMS.get();
        return what == null || what.get() != this;
    }

    public boolean notLoaded() {
        return !this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public TileEntity getTile() {
        return this;
    }

    public static void registerTileItem(Class c, ItemStackSrc wat) {
        ITEM_STACKS.put(c, wat);
    }

    protected ItemStack getItemFromTile(Object obj) {
        ItemStackSrc src = ITEM_STACKS.get(obj.getClass());
        if (src == null) {
            return null;
        }
        return src.stack(1);
    }

    protected boolean hasHandlerFor(TileEventType type) {
        List<AETileEventHandler> list = this.getHandlerListFor(type);
        return list != null && !list.isEmpty();
    }

    protected List<AETileEventHandler> getHandlerListFor(TileEventType type) {
        List<AETileEventHandler> list;
        Class<?> clz = this.getClass();
        EnumMap<TileEventType, List<AETileEventHandler>> handlerSet = HANDLERS.get(clz);
        if (handlerSet == null) {
            handlerSet = new EnumMap(TileEventType.class);
            HANDLERS.put(clz, handlerSet);
            for (Method m : clz.getMethods()) {
                TileEvent te = m.getAnnotation(TileEvent.class);
                if (te == null) continue;
                this.addHandler(handlerSet, te.value(), m);
            }
        }
        if ((list = handlerSet.get((Object)type)) == null) {
            list = new LinkedList<AETileEventHandler>();
            handlerSet.put(type, list);
        }
        return list;
    }

    private void addHandler(EnumMap<TileEventType, List<AETileEventHandler>> handlerSet, TileEventType value, Method m) {
        List<AETileEventHandler> list = handlerSet.get((Object)value);
        if (list == null) {
            list = new ArrayList<AETileEventHandler>();
            handlerSet.put(value, list);
        }
        list.add(new AETileEventHandler(m, value));
    }

    public final boolean canUpdate() {
        return this.hasHandlerFor(TileEventType.TICK);
    }

    public final void Tick() {
    }

    public final void func_145845_h() {
        for (AETileEventHandler h : this.getHandlerListFor(TileEventType.TICK)) {
            h.Tick(this);
        }
    }

    public void onChunkUnload() {
        if (!this.func_145837_r()) {
            this.func_145843_s();
        }
    }

    public void onChunkLoad() {
        if (this.func_145837_r()) {
            this.func_145829_t();
        }
    }

    public final void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.canBeRotated()) {
            data.func_74778_a("orientation_forward", this.forward.name());
            data.func_74778_a("orientation_up", this.up.name());
        }
        if (this.customName != null) {
            data.func_74778_a("customName", this.customName);
        }
        for (AETileEventHandler h : this.getHandlerListFor(TileEventType.WORLD_NBT_WRITE)) {
            h.writeToNBT(this, data);
        }
    }

    public final void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.customName = data.func_74764_b("customName") ? data.func_74779_i("customName") : null;
        try {
            if (this.canBeRotated()) {
                this.forward = ForgeDirection.valueOf((String)data.func_74779_i("orientation_forward"));
                this.up = ForgeDirection.valueOf((String)data.func_74779_i("orientation_up"));
            }
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        for (AETileEventHandler h : this.getHandlerListFor(TileEventType.WORLD_NBT_READ)) {
            h.readFromNBT(this, data);
        }
    }

    public final void writeToStream(ByteBuf data) {
        try {
            if (this.canBeRotated()) {
                byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
                data.writeByte((int)orientation);
            }
            for (AETileEventHandler h : this.getHandlerListFor(TileEventType.NETWORK_WRITE)) {
                h.writeToStream(this, data);
            }
        }
        catch (Throwable t) {
            AELog.error(t);
        }
    }

    public final boolean readFromStream(ByteBuf data) {
        boolean output = false;
        try {
            if (this.canBeRotated()) {
                ForgeDirection old_Forward = this.forward;
                ForgeDirection old_Up = this.up;
                byte orientation = data.readByte();
                this.forward = ForgeDirection.getOrientation((int)(orientation & 7));
                this.up = ForgeDirection.getOrientation((int)(orientation >> 3));
                output = this.forward != old_Forward || this.up != old_Up;
            }
            this.renderFragment = 100;
            for (AETileEventHandler h : this.getHandlerListFor(TileEventType.NETWORK_READ)) {
                if (!h.readFromStream(this, data)) continue;
                output = true;
            }
            if ((this.renderFragment & 1) == 1) {
                output = true;
            }
            this.renderFragment = 0;
        }
        catch (Throwable t) {
            AELog.error(t);
        }
        return output;
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public ForgeDirection getForward() {
        return this.forward;
    }

    @Override
    public ForgeDirection getUp() {
        return this.up;
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.markForUpdate();
        Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onPlacement(ItemStack stack, EntityPlayer player, int side) {
        if (stack.func_77942_o()) {
            this.uploadSettings(SettingsFrom.DISMANTLE_ITEM, stack.func_77978_p());
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        ByteBuf stream = Unpooled.buffer();
        try {
            this.writeToStream(stream);
            if (stream.readableBytes() == 0) {
                return null;
            }
        }
        catch (Throwable t) {
            AELog.error(t);
        }
        stream.capacity(stream.readableBytes());
        data.func_74773_a("X", stream.array());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 64, data);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        ByteBuf stream;
        if (pkt.func_148853_f() == 64 && this.readFromStream(stream = Unpooled.copiedBuffer((byte[])pkt.func_148857_g().func_74770_j("X")))) {
            this.markForUpdate();
        }
    }

    public void markForUpdate() {
        if (this.renderFragment > 0) {
            this.renderFragment |= 1;
        } else if (this.field_145850_b != null) {
            AELog.blockUpdate(this.field_145851_c, this.field_145848_d, this.field_145849_e, this);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void getDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        if (this instanceof IInventory) {
            IInventory inv = (IInventory)this;
            for (int l = 0; l < inv.func_70302_i_(); ++l) {
                ItemStack is = inv.func_70301_a(l);
                if (is == null) continue;
                drops.add(is);
            }
        }
    }

    public void getNoDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
    }

    public void onReady() {
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        IInventory inv;
        IConfigManager cm;
        if (compound != null && this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.readFromNBT(compound);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            pHost.setPriority(compound.func_74762_e("priority"));
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) != null && inv instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.func_70302_i_());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.func_70302_i_(); ++x) {
                target.func_70299_a(x, tmp.func_70301_a(x));
            }
        }
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        IInventory inv;
        IConfigManager cm;
        NBTTagCompound output = new NBTTagCompound();
        if (this.hasCustomName()) {
            NBTTagCompound dsp = new NBTTagCompound();
            dsp.func_74778_a("Name", this.getCustomName());
            output.func_74782_a("display", (NBTBase)dsp);
        }
        if (this instanceof IConfigurableObject && (cm = ((IConfigurableObject)((Object)this)).getConfigManager()) != null) {
            cm.writeToNBT(output);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            output.func_74768_a("priority", pHost.getPriority());
        }
        if (this instanceof ISegmentedInventory && (inv = ((ISegmentedInventory)((Object)this)).getInventoryByName("config")) != null && inv instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
        }
        return output.func_82582_d() ? null : output;
    }

    public void securityBreak() {
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        this.disableDrops();
    }

    public void saveChanges() {
        super.func_70296_d();
    }

    public boolean requiresTESR() {
        return false;
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Override
    public String getCustomName() {
        return this.hasCustomName() ? this.customName : this.getClass().getSimpleName();
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }
}

