/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import net.minecraft.nbt.NBTTagCompound;

public class VersionChecker
implements Runnable {
    private static final int FOUR_HOURS = 14400000;
    private final long delay;

    public VersionChecker() {
        long now = new Date().getTime();
        long timeDiff = now - AEConfig.instance.latestTimeStamp;
        this.delay = Math.max(1L, 14400000L - timeDiff);
    }

    @Override
    public void run() {
        try {
            this.sleep(this.delay);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        while (true) {
            Thread.yield();
            try {
                JsonElement element;
                int version;
                String inputLine;
                String MCVersion = Loader.instance().getMCVersionString().replace("Minecraft ", "");
                URL url = new URL("http://feeds.ae-mod.info/latest.json?VersionMC=" + MCVersion + "&Channel=" + "beta" + "&CurrentVersion=" + "rv2-beta-8");
                URLConnection yc = url.openConnection();
                yc.setRequestProperty("User-Agent", "AE2/rv2-beta-8 (Channel:beta," + MCVersion.replace(" ", ":") + ')');
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                StringBuilder Version = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    Version.append(inputLine);
                }
                in.close();
                if (Version.length() > 2 && (version = (element = new JsonParser().parse(Version.toString())).getAsJsonObject().get("FormatVersion").getAsInt()) == 1) {
                    JsonObject Meta = element.getAsJsonObject().get("Meta").getAsJsonObject();
                    JsonArray Versions = element.getAsJsonObject().get("Versions").getAsJsonArray();
                    if (Versions.size() > 0) {
                        JsonObject Latest = Versions.get(0).getAsJsonObject();
                        AEConfig.instance.latestVersion = Latest.get("Version").getAsString();
                        AEConfig.instance.latestTimeStamp = new Date().getTime();
                        AEConfig.instance.save();
                        if (!"rv2-beta-8".equals(AEConfig.instance.latestVersion)) {
                            NBTTagCompound versionInf = new NBTTagCompound();
                            versionInf.func_74778_a("modDisplayName", "Applied Energistics 2");
                            versionInf.func_74778_a("oldVersion", "rv2-beta-8");
                            versionInf.func_74778_a("newVersion", AEConfig.instance.latestVersion);
                            versionInf.func_74778_a("updateUrl", Latest.get("UserBuild").getAsString());
                            versionInf.func_74757_a("isDirectLink", true);
                            JsonElement changeLog = Latest.get("ChangeLog");
                            if (changeLog == null) {
                                versionInf.func_74778_a("changeLog", "For full change log please see: " + Meta.get("DownloadLink").getAsString());
                            } else {
                                versionInf.func_74778_a("changeLog", changeLog.getAsString());
                            }
                            versionInf.func_74778_a("newFileName", "appliedenergistics2-" + AEConfig.instance.latestVersion + ".jar");
                            FMLInterModComms.sendRuntimeMessage((Object)AppEng.instance, (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)versionInf);
                            AELog.info("Stopping VersionChecker", new Object[0]);
                            return;
                        }
                    }
                }
                this.sleep(14400000L);
                continue;
            }
            catch (Exception e) {
                try {
                    this.sleep(14400000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    AELog.error(e);
                    continue;
                }
            }
            break;
        }
    }

    private void sleep(long i) throws InterruptedException {
        Thread.sleep(i);
    }
}

