/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.TunnelType;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBC;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.inventory.AppEngNullInventory;
import appeng.transformer.annotations.integration;
import appeng.util.Platform;
import appeng.util.inv.WrapperBCPipe;
import appeng.util.inv.WrapperChainedInventory;
import appeng.util.inv.WrapperMCISidedInventory;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@integration.Interface(iface="buildcraft.api.transport.IPipeConnection", iname="BC")
public class PartP2PItems
extends PartP2PTunnel<PartP2PItems>
implements IPipeConnection,
ISidedInventory,
IGridTickable {
    int oldSize = 0;
    boolean requested;
    IInventory cachedInv;
    final LinkedList<IInventory> which = new LinkedList();

    @Override
    public TunnelType getTunnelType() {
        return TunnelType.ITEM;
    }

    public PartP2PItems(ItemStack is) {
        super(is);
    }

    IInventory getOutputInv() {
        IInventory output = null;
        if (this.proxy.isActive()) {
            IBC buildcraft;
            TileEntity te = this.tile.func_145831_w().func_147438_o(this.tile.field_145851_c + this.side.offsetX, this.tile.field_145848_d + this.side.offsetY, this.tile.field_145849_e + this.side.offsetZ);
            if (this.which.contains(this)) {
                return null;
            }
            this.which.add((IInventory)this);
            if (AppEng.instance.isIntegrationEnabled(IntegrationType.BC) && (buildcraft = (IBC)AppEng.instance.getIntegration(IntegrationType.BC)) != null && buildcraft.isPipe(te, this.side.getOpposite())) {
                try {
                    output = new WrapperBCPipe(te, this.side.getOpposite());
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (output == null) {
                if (te instanceof TileEntityChest) {
                    output = Platform.GetChestInv(te);
                } else if (te instanceof ISidedInventory) {
                    output = new WrapperMCISidedInventory((ISidedInventory)te, this.side.getOpposite());
                } else if (te instanceof IInventory) {
                    output = (IInventory)te;
                }
            }
            this.which.pop();
        }
        return output;
    }

    @Override
    public void onNeighborChanged() {
        this.cachedInv = null;
        PartP2PItems input = (PartP2PItems)this.getInput();
        if (input != null && this.output) {
            input.onTunnelNetworkChange();
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ItemTunnel.min, TickRates.ItemTunnel.max, false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        boolean wasReq = this.requested;
        if (this.requested && this.cachedInv != null) {
            ((WrapperChainedInventory)this.cachedInv).cycleOrder();
        }
        this.requested = false;
        return wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    IInventory getDestination() {
        TunnelCollection itemTunnels;
        this.requested = true;
        if (this.cachedInv != null) {
            return this.cachedInv;
        }
        LinkedList<IInventory> outs = new LinkedList<IInventory>();
        try {
            itemTunnels = this.getOutputs();
        }
        catch (GridAccessException e) {
            return new AppEngNullInventory();
        }
        for (PartP2PItems t : itemTunnels) {
            IInventory inv = t.getOutputInv();
            if (inv == null) continue;
            if (Platform.getRandomInt() % 2 == 0) {
                outs.add(inv);
                continue;
            }
            outs.add(0, inv);
        }
        this.cachedInv = new WrapperChainedInventory(outs);
        return this.cachedInv;
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        if (!this.output) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        if (!this.output) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        if (!this.output) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        if (!this.output) {
            this.cachedInv = null;
            int olderSize = this.oldSize;
            this.oldSize = this.getDestination().func_70302_i_();
            if (olderSize != this.oldSize) {
                this.getHost().notifyNeighbors();
            }
        } else {
            PartP2PItems input = (PartP2PItems)this.getInput();
            if (input != null) {
                input.getHost().notifyNeighbors();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150438_bZ.func_149733_h(0);
    }

    public int func_70302_i_() {
        return this.getDestination().func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.getDestination().func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.getDestination().func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.getDestination().func_70299_a(i, itemstack);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.getDestination().func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.getDestination().func_94041_b(i, itemstack);
    }

    public int[] func_94128_d(int var1) {
        int[] slots = new int[this.func_70302_i_()];
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            slots[x] = x;
        }
        return slots;
    }

    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.getDestination().func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    @integration.Method(iname="BC")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return this.side == with && type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public void func_70296_d() {
    }
}

