/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.config.TunnelType;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IMJ5;
import appeng.integration.abstraction.IMJ6;
import appeng.integration.abstraction.helpers.BaseMJPerdition;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.transformer.annotations.integration;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.ISidedBatteryProvider;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@integration.InterfaceList(value={@integration.Interface(iface="buildcraft.api.mj.ISidedBatteryProvider", iname="MJ6"), @integration.Interface(iface="buildcraft.api.mj.IBatteryObject", iname="MJ6"), @integration.Interface(iface="buildcraft.api.power.IPowerReceptor", iname="MJ5"), @integration.Interface(iface="appeng.api.networking.ticking.IGridTickable", iname="MJ5")})
public class PartP2PBCPower
extends PartP2PTunnel<PartP2PBCPower>
implements IPowerReceptor,
ISidedBatteryProvider,
IBatteryObject,
IGridTickable {
    BaseMJPerdition pp;

    @Override
    public TunnelType getTunnelType() {
        return TunnelType.BC_POWER;
    }

    public PartP2PBCPower(ItemStack is) {
        super(is);
        if (!AppEng.instance.isIntegrationEnabled(IntegrationType.MJ5) && !AppEng.instance.isIntegrationEnabled(IntegrationType.MJ6)) {
            throw new RuntimeException("MJ Not installed!");
        }
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.MJ5)) {
            this.pp = (BaseMJPerdition)((IMJ5)AppEng.instance.getIntegration(IntegrationType.MJ5)).createPerdition(this);
            if (this.pp != null) {
                this.pp.configure(1, 380, 0.2f, 1000);
            }
        }
    }

    @Override
    @integration.Method(iname="MJ5")
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.MJTunnel.min, TickRates.MJTunnel.max, false, false);
    }

    @Override
    @integration.Method(iname="MJ5")
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (!this.output && this.proxy.isActive()) {
            TunnelCollection tunnels;
            float totalRequiredPower = 0.0f;
            try {
                tunnels = this.getOutputs();
            }
            catch (GridAccessException e) {
                return TickRateModulation.IDLE;
            }
            for (PartP2PBCPower o : tunnels) {
                PowerHandler.PowerReceiver tp;
                IPowerReceptor target = o.getPowerTarget();
                if (target == null || (tp = target.getPowerReceiver(this.side.getOpposite())) == null) continue;
                double request = tp.powerRequest();
                if (request > tp.getMaxEnergyReceived()) {
                    request = tp.getMaxEnergyReceived();
                }
                if (!(request > 0.01) || !(request > tp.getMinEnergyReceived())) continue;
                totalRequiredPower = (float)((double)totalRequiredPower + request);
            }
            if ((double)totalRequiredPower < 0.1) {
                return TickRateModulation.SLOWER;
            }
            double currentTotal = this.pp.getPowerReceiver().getEnergyStored();
            if (currentTotal < 0.01) {
                return TickRateModulation.SLOWER;
            }
            for (PartP2PBCPower o : tunnels) {
                PowerHandler.PowerReceiver tp;
                IPowerReceptor target = o.getPowerTarget();
                if (target == null || (tp = target.getPowerReceiver(this.side.getOpposite())) == null) continue;
                double request = tp.powerRequest();
                if (request > tp.getMaxEnergyReceived()) {
                    request = tp.getMaxEnergyReceived();
                }
                if (!(request > 0.01) || !(request > tp.getMinEnergyReceived())) continue;
                double toPull = currentTotal * (request / (double)totalRequiredPower);
                double pulled = this.pp.useEnergy(0.0, toPull, true);
                this.QueueTunnelDrain(PowerUnits.MJ, pulled);
                tp.receiveEnergy(PowerHandler.Type.PIPE, pulled, o.side.getOpposite());
            }
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @integration.Method(iname="MJ6")
    private IBatteryObject getTargetBattery() {
        TileEntity te = this.getWorld().func_147438_o(this.tile.field_145851_c + this.side.offsetX, this.tile.field_145848_d + this.side.offsetY, this.tile.field_145849_e + this.side.offsetZ);
        if (te != null) {
            IBatteryObject bo = MjAPI.getMjBattery((Object)te, (String)"buildcraft.kinesis", (ForgeDirection)this.side.getOpposite());
            if (bo != null) {
                return bo;
            }
            return ((IMJ6)AppEng.instance.getIntegration(IntegrationType.MJ6)).provider(te, this.side.getOpposite());
        }
        return null;
    }

    @integration.Method(iname="MJ5")
    private IPowerReceptor getPowerTarget() {
        TileEntity te = this.getWorld().func_147438_o(this.tile.field_145851_c + this.side.offsetX, this.tile.field_145848_d + this.side.offsetY, this.tile.field_145849_e + this.side.offsetZ);
        if (te != null && te instanceof IPowerReceptor) {
            return (IPowerReceptor)te;
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.pp != null) {
            this.pp.writeToNBT(tag);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (this.pp != null) {
            this.pp.readFromNBT(tag);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150475_bE.func_149733_h(0);
    }

    @integration.Method(iname="MJ5")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.pp.getPowerReceiver();
    }

    @integration.Method(iname="MJ5")
    public void doWork(PowerHandler workProvider) {
    }

    public World getWorld() {
        return this.tile.func_145831_w();
    }

    @integration.Method(iname="MJ6")
    public IBatteryObject getMjBattery(String kind, ForgeDirection direction) {
        return this;
    }

    @integration.Method(iname="MJ6")
    public double getEnergyRequested() {
        try {
            double totalRequiredPower = 0.0;
            for (PartP2PBCPower g : this.getOutputs()) {
                IBatteryObject o = g.getTargetBattery();
                if (o == null) continue;
                totalRequiredPower += o.getEnergyRequested();
            }
            return totalRequiredPower;
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @integration.Method(iname="MJ6")
    public double addEnergy(double mj) {
        return this.addEnergyInternal(mj, false, false);
    }

    @integration.Method(iname="MJ6")
    public double addEnergy(double mj, boolean ignoreCycleLimit) {
        return this.addEnergyInternal(mj, true, ignoreCycleLimit);
    }

    @integration.Method(iname="MJ6")
    private double addEnergyInternal(double mj, boolean cycleLimitMode, boolean ignoreCycleLimit) {
        if (this.output || !this.proxy.isActive()) {
            return 0.0;
        }
        double originalInput = mj;
        try {
            IBatteryObject o;
            TunnelCollection outs = this.getOutputs();
            double outputs = 0.0;
            for (PartP2PBCPower g : outs) {
                o = g.getTargetBattery();
                if (o == null) continue;
                outputs += 1.0;
            }
            if (outputs < 1.0E-7) {
                return 0.0;
            }
            for (PartP2PBCPower g : outs) {
                o = g.getTargetBattery();
                if (o == null) continue;
                double fraction = originalInput / outputs;
                fraction = cycleLimitMode ? o.addEnergy(fraction) : o.addEnergy(fraction, ignoreCycleLimit);
                mj -= fraction;
            }
            if (mj > 0.0) {
                for (PartP2PBCPower g : outs) {
                    o = g.getTargetBattery();
                    if (o == null) continue;
                    if (cycleLimitMode) {
                        mj -= o.addEnergy(mj);
                        continue;
                    }
                    mj -= o.addEnergy(mj, ignoreCycleLimit);
                }
            }
            return originalInput - mj;
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @integration.Method(iname="MJ6")
    public double getEnergyStored() {
        try {
            double totalRequiredPower = 0.0;
            for (PartP2PBCPower g : this.getOutputs()) {
                IBatteryObject o = g.getTargetBattery();
                if (o == null) continue;
                totalRequiredPower += o.getEnergyStored();
            }
            return totalRequiredPower;
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @integration.Method(iname="MJ6")
    public void setEnergyStored(double mj) {
    }

    public double maxCapacity() {
        try {
            double totalRequiredPower = 0.0;
            for (PartP2PBCPower g : this.getOutputs()) {
                IBatteryObject o = g.getTargetBattery();
                if (o == null) continue;
                totalRequiredPower += o.maxCapacity();
            }
            return totalRequiredPower;
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @integration.Method(iname="MJ6")
    public double minimumConsumption() {
        try {
            double totalRequiredPower = 1.0E12;
            for (PartP2PBCPower g : this.getOutputs()) {
                IBatteryObject o = g.getTargetBattery();
                if (o == null) continue;
                totalRequiredPower = Math.min(totalRequiredPower, o.minimumConsumption());
            }
            return totalRequiredPower;
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @integration.Method(iname="MJ6")
    public double maxReceivedPerCycle() {
        try {
            double totalRequiredPower = 1000000.0;
            for (PartP2PBCPower g : this.getOutputs()) {
                IBatteryObject o = g.getTargetBattery();
                if (o == null) continue;
                totalRequiredPower = Math.min(totalRequiredPower, o.maxReceivedPerCycle());
            }
            return totalRequiredPower;
        }
        catch (GridAccessException e) {
            return 0.0;
        }
    }

    @integration.Method(iname="MJ6")
    public IBatteryObject reconfigure(double maxCapacity, double maxReceivedPerCycle, double minimumConsumption) {
        return this;
    }

    @integration.Method(iname="MJ6")
    public String kind() {
        return "tunnel";
    }
}

