/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.texture.OffsetIcon;
import appeng.parts.networking.PartCable;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.AbstractCollection;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PartCableCovered
extends PartCable {
    @MENetworkEventSubscribe
    public void channelUpdated(MENetworkChannelsChanged c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    public PartCableCovered(Class c, ItemStack is) {
        super(c, is);
    }

    public PartCableCovered(ItemStack is) {
        this(PartCableCovered.class, is);
    }

    @Override
    public IIcon getTexture(AEColor c) {
        return this.getCoveredTexture(c);
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.COVERED;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 5.0, 11.0, 11.0, 11.0);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.connections = n.getConnectedSides();
            } else {
                this.connections.clear();
            }
        }
        for (ForgeDirection of : this.connections) {
            switch (of) {
                case DOWN: {
                    bch.addBox(5.0, 0.0, 5.0, 11.0, 5.0, 11.0);
                    break;
                }
                case EAST: {
                    bch.addBox(11.0, 5.0, 5.0, 16.0, 11.0, 11.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(5.0, 5.0, 0.0, 11.0, 11.0, 5.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(5.0, 11.0, 5.0, 11.0, 16.0, 11.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 5.0, 5.0, 5.0, 11.0, 11.0);
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        GL11.glTranslated((double)-0.0, (double)-0.0, (double)0.3);
        rh.setBounds(5.0f, 5.0f, 2.0f, 11.0f, 11.0f, 14.0f);
        float offU = 0.0f;
        float offV = 9.0f;
        OffsetIcon main = new OffsetIcon(this.getTexture(this.getCableColor()), offU, offV);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.UP, ForgeDirection.DOWN)) {
            rh.renderInventoryFace(main, side, renderer);
        }
        offU = 9.0f;
        offV = 0.0f;
        main = new OffsetIcon(this.getTexture(this.getCableColor()), offU, offV);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.EAST, ForgeDirection.WEST)) {
            rh.renderInventoryFace(main, side, renderer);
        }
        main = new OffsetIcon(this.getTexture(this.getCableColor()), 0.0f, 0.0f);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.SOUTH, ForgeDirection.NORTH)) {
            rh.renderInventoryFace(main, side, renderer);
        }
        rh.setTexture(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimplifiedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(this.getTexture(this.getCableColor()));
        Object sides = this.connections.clone();
        boolean hasBuses = false;
        IPartHost ph = this.getHost();
        block13: for (ForgeDirection of : EnumSet.complementOf(this.connections)) {
            int len;
            IPart bp = ph.getPart(of);
            if (!(bp instanceof IGridHost)) continue;
            if (of != ForgeDirection.UNKNOWN) {
                ((AbstractCollection)sides).add(of);
                hasBuses = true;
            }
            if ((len = bp.cableConnectionRenderTo()) >= 8) continue;
            switch (of) {
                case DOWN: {
                    rh.setBounds(6.0f, len, 6.0f, 10.0f, 5.0f, 10.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(11.0f, 6.0f, 6.0f, 16 - len, 10.0f, 10.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(6.0f, 6.0f, len, 10.0f, 10.0f, 5.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16 - len);
                    break;
                }
                case UP: {
                    rh.setBounds(6.0f, 11.0f, 6.0f, 10.0f, 16 - len, 10.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(len, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
                    break;
                }
                default: {
                    continue block13;
                }
            }
            rh.renderBlock(x, y, z, renderer);
        }
        if (((AbstractCollection)sides).size() != 2 || !this.nonLinear((EnumSet<ForgeDirection>)sides) || hasBuses) {
            for (ForgeDirection of : this.connections) {
                this.renderCoveredConnection(x, y, z, rh, renderer, this.channelsOnSide[of.ordinal()], of);
            }
            rh.setTexture(this.getTexture(this.getCableColor()));
            rh.setBounds(5.0f, 5.0f, 5.0f, 11.0f, 11.0f, 11.0f);
            rh.renderBlock(x, y, z, renderer);
        } else {
            IIcon def = this.getTexture(this.getCableColor());
            OffsetIcon off = new OffsetIcon(def, 0.0f, -12.0f);
            for (ForgeDirection of : this.connections) {
                switch (of) {
                    case DOWN: 
                    case UP: {
                        rh.setTexture(def, def, off, off, off, off);
                        renderer.func_147782_a(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        rh.setTexture(off, off, off, off, def, def);
                        renderer.field_147873_r = 1;
                        renderer.field_147875_q = 1;
                        renderer.field_147867_u = 1;
                        renderer.field_147865_v = 1;
                        renderer.func_147782_a(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        rh.setTexture(off, off, def, def, off, off);
                        renderer.field_147871_s = 1;
                        renderer.field_147869_t = 1;
                        renderer.func_147782_a(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0);
                        break;
                    }
                }
            }
            rh.renderBlockCurrentBounds(x, y, z, renderer);
        }
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        rh.setTexture(null);
    }
}

