/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class PartSharedItemBus
extends PartUpgradeable
implements IGridTickable {
    final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9);
    int adaptorHash = 0;
    InventoryAdaptor adaptor;
    boolean lastRedstone = false;

    private TileEntity getTileEntity(TileEntity self, int x, int y, int z) {
        World w = self.func_145831_w();
        if (w.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return w.func_147438_o(x, y, z);
        }
        return null;
    }

    public PartSharedItemBus(Class c, ItemStack is) {
        super(c, is);
    }

    @Override
    public void upgradesChanged() {
        this.updateState();
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.config.func_70302_i_());
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.config.writeToNBT(extra, "config");
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.config.readFromNBT(extra, "config");
    }

    InventoryAdaptor getHandler() {
        TileEntity self = this.getHost().getTile();
        TileEntity target = this.getTileEntity(self, self.field_145851_c + this.side.offsetX, self.field_145848_d + this.side.offsetY, self.field_145849_e + this.side.offsetZ);
        int newAdaptorHash = Platform.generateTileHash(target);
        if (this.adaptorHash == newAdaptorHash && newAdaptorHash != 0) {
            return this.adaptor;
        }
        this.adaptorHash = newAdaptorHash;
        this.adaptor = InventoryAdaptor.getAdaptor(target, this.side.getOpposite());
        return this.adaptor;
    }

    abstract TickRateModulation doBusWork();

    @Override
    public void onNeighborChanged() {
        this.updateState();
        if (this.lastRedstone != this.host.hasRedstone(this.side)) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.proxy.getTick().wakeDevice(this.proxy.getNode());
            } else {
                this.proxy.getTick().sleepDevice(this.proxy.getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }
}

