/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.helpers.MultiCraftingTracker;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class PartExportBus
extends PartSharedItemBus
implements ICraftingRequester {
    final MultiCraftingTracker cratingTracker = new MultiCraftingTracker(this, 9);
    final BaseActionSource mySrc;
    long itemToSend = 1L;
    boolean didSomething = false;

    public PartExportBus(ItemStack is) {
        super(PartExportBus.class, is);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.settings.registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.settings.registerSetting(Settings.CRAFT_ONLY, YesNo.NO);
        this.mySrc = new MachineSource(this);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.cratingTracker.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.cratingTracker.writeToNBT(extra);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.side, GuiBridge.GUI_BUS);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimplifiedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartExportSides.getIcon(), CableBusTextures.PartExportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 12.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    TickRateModulation doBusWork() {
        block14: {
            if (!this.proxy.isActive()) {
                return TickRateModulation.IDLE;
            }
            this.itemToSend = 1L;
            this.didSomething = false;
            switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
                default: {
                    this.itemToSend = 1L;
                    break;
                }
                case 1: {
                    this.itemToSend = 8L;
                    break;
                }
                case 2: {
                    this.itemToSend = 32L;
                    break;
                }
                case 3: {
                    this.itemToSend = 64L;
                    break;
                }
                case 4: {
                    this.itemToSend = 96L;
                }
            }
            try {
                InventoryAdaptor d = this.getHandler();
                IMEMonitor<IAEItemStack> inv = this.proxy.getStorage().getItemInventory();
                IEnergyGrid energy = this.proxy.getEnergy();
                ICraftingGrid cg = this.proxy.getCrafting();
                FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
                if (d == null) break block14;
                for (int x = 0; x < this.availableSlots() && this.itemToSend > 0L; ++x) {
                    IAEItemStack ais = this.config.getAEStackInSlot(x);
                    if (ais == null || this.itemToSend <= 0L || this.craftOnly()) {
                        if (!this.isCraftingEnabled()) continue;
                        this.didSomething = this.cratingTracker.handleCrafting(x, this.itemToSend, ais, d, this.getTile().func_145831_w(), this.proxy.getGrid(), cg, this.mySrc) || this.didSomething;
                        continue;
                    }
                    long before = this.itemToSend;
                    if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
                        for (IAEItemStack o : ImmutableList.copyOf(inv.getStorageList().findFuzzy(ais, fzMode))) {
                            this.pushItemIntoTarget(d, energy, inv, o);
                            if (this.itemToSend > 0L) continue;
                            break;
                        }
                    } else {
                        this.pushItemIntoTarget(d, energy, inv, ais);
                    }
                    if (this.itemToSend != before || !this.isCraftingEnabled()) continue;
                    this.didSomething = this.cratingTracker.handleCrafting(x, this.itemToSend, ais, d, this.getTile().func_145831_w(), this.proxy.getGrid(), cg, this.mySrc) || this.didSomething;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return this.didSomething ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private boolean craftOnly() {
        return this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.getInstalledUpgrades(Upgrades.CRAFTING) > 0;
    }

    private void pushItemIntoTarget(InventoryAdaptor d, IEnergyGrid energy, IMEInventory<IAEItemStack> inv, IAEItemStack ais) {
        long canFit;
        ItemStack is = ais.getItemStack();
        is.field_77994_a = (int)this.itemToSend;
        ItemStack o = d.simulateAdd(is);
        long l = canFit = o == null ? this.itemToSend : this.itemToSend - (long)o.field_77994_a;
        if (canFit > 0L) {
            ais = ais.copy();
            ais.setStackSize(canFit);
            IAEItemStack itemsToAdd = Platform.poweredExtraction(energy, inv, ais, this.mySrc);
            if (itemsToAdd != null) {
                this.itemToSend -= itemsToAdd.getStackSize();
                ItemStack failed = d.addItems(itemsToAdd.getItemStack());
                if (failed != null) {
                    ais.setStackSize(failed.field_77994_a);
                    inv.injectItems(ais, Actionable.MODULATE, this.mySrc);
                } else {
                    this.didSomething = true;
                }
            }
        }
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        InventoryAdaptor d = this.getHandler();
        try {
            double power;
            IEnergyGrid energy;
            if (d != null && this.proxy.isActive() && (energy = this.proxy.getEnergy()).extractAEPower(power = (double)items.getStackSize(), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                if (mode == Actionable.MODULATE) {
                    return AEItemStack.create(d.addItems(items.getItemStack()));
                }
                return AEItemStack.create(d.simulateAdd(items.getItemStack()));
            }
        }
        catch (GridAccessException e) {
            AELog.error(e);
        }
        return items;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.settings.getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ExportBus.min, TickRates.ExportBus.max, this.isSleeping(), false);
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.cratingTracker.getRequestedJobs();
    }

    @Override
    public void jobStateChange(ICraftingLink link) {
        this.cratingTracker.jobStateChange(link);
    }
}

