/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.definitions.Items;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.core.AppEng;
import appeng.core.CommonHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.core.sync.packets.PacketPartPlacement;
import appeng.facade.IFacadeItem;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBC;
import appeng.integration.abstraction.IFMP;
import appeng.integration.abstraction.IImmibisMicroblocks;
import appeng.util.LookDirection;
import appeng.util.Platform;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PartPlacement {
    private final ThreadLocal<Object> placing = new ThreadLocal();
    private boolean wasCanceled = false;
    public static float eyeHeight = 0.0f;

    @SubscribeEvent
    public void playerInteract(TickEvent.ClientTickEvent event) {
        this.wasCanceled = false;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.entityPlayer.field_70170_p.field_72995_K) {
            MovingObjectPosition mop = Platform.rayTrace(event.entityPlayer, true, false);
            Minecraft mc = Minecraft.func_71410_x();
            float f = 1.0f;
            double d0 = mc.field_71442_b.func_78757_d();
            Vec3 vec3 = mc.field_71451_h.func_70666_h(f);
            if (mop != null && mop.field_72307_f.func_72438_d(vec3) < d0) {
                World w = event.entity.field_70170_p;
                TileEntity te = w.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (te instanceof IPartHost && this.wasCanceled) {
                    event.setCanceled(true);
                }
            } else {
                boolean supportedItem;
                ItemStack held = event.entityPlayer.func_70694_bm();
                Items items = AEApi.instance().items();
                boolean sameAsMemoryCard = items.itemMemoryCard != null && items.itemMemoryCard.sameAsStack(held);
                boolean sameAsColorApp = items.itemColorApplicator != null && items.itemColorApplicator.sameAsStack(held);
                boolean bl = supportedItem = sameAsMemoryCard || sameAsColorApp;
                if (event.entityPlayer.func_70093_af() && held != null && supportedItem) {
                    NetworkHandler.instance.sendToServer(new PacketClick(event.x, event.y, event.z, event.face, 0.0f, 0.0f, 0.0f));
                }
            }
        } else if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70170_p.field_72995_K) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            ItemStack held = event.entityPlayer.func_70694_bm();
            if (PartPlacement.place(held, event.x, event.y, event.z, event.face, event.entityPlayer, event.entityPlayer.field_70170_p, PlaceType.INTERACT_FIRST_PASS, 0)) {
                event.setCanceled(true);
                this.wasCanceled = true;
            }
            this.placing.set(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean place(ItemStack held, int x, int y, int z, int face, EntityPlayer player, World world, PlaceType pass, int depth) {
        DimensionalCoord dc;
        IFacadePart fp;
        if (depth > 3) {
            return false;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)face);
        if (held != null && Platform.isWrench(player, held, x, y, z) && player.func_70093_af()) {
            if (!Platform.hasPermissions(new DimensionalCoord(world, x, y, z), player)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            TileEntity tile = world.func_147438_o(x, y, z);
            IPartHost host = null;
            if (tile instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            if (host == null) return false;
            if (world.field_72995_K) {
                player.func_71038_i();
                NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                return true;
            }
            LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
            MovingObjectPosition mop = block.func_149731_a(world, x, y, z, dir.a, dir.b);
            if (mop == null) return true;
            LinkedList<ItemStack> is = new LinkedList<ItemStack>();
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.field_72307_f.func_72441_c((double)(-mop.field_72311_b), (double)(-mop.field_72312_c), (double)(-mop.field_72309_d)));
            if (sp.part != null) {
                is.add(sp.part.getItemStack(PartItemStack.Wrench));
                sp.part.getDrops(is, true);
                host.removePart(sp.side, false);
            }
            if (sp.facade != null) {
                is.add(sp.facade.getItemStack());
                host.getFacadeContainer().removeFacade(host, sp.side);
                Platform.notifyBlocksOfNeighbors(world, x, y, z);
            }
            if (host.isEmpty()) {
                host.cleanup();
            }
            if (is.isEmpty()) return true;
            Platform.spawnDrops(world, x, y, z, is);
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        IPartHost host = null;
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
        }
        if (held != null && (fp = PartPlacement.isFacade(held, side)) != null) {
            if (host == null) return false;
            if (world.field_72995_K) {
                player.func_71038_i();
                NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                return true;
            }
            if (host.getPart(ForgeDirection.UNKNOWN) == null) {
                return false;
            }
            if (!host.canAddPart(held, side)) return false;
            if (!host.getFacadeContainer().addFacade(fp)) return false;
            host.markForUpdate();
            if (player.field_71075_bZ.field_75098_d) return true;
            --held.field_77994_a;
            if (held.field_77994_a != 0) return true;
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
            return true;
        }
        if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
            host = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getOrCreateHost(tile);
        }
        if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.ImmibisMicroblocks)) {
            host = ((IImmibisMicroblocks)AppEng.instance.getIntegration(IntegrationType.ImmibisMicroblocks)).getOrCreateHost(player, face, tile);
        }
        Block block = world.func_147439_a(x, y, z);
        if (host != null && player.func_70093_af() && block != null) {
            LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
            MovingObjectPosition mop = block.func_149731_a(world, x, y, z, dir.a, dir.b);
            if (mop != null) {
                mop.field_72307_f = mop.field_72307_f.func_72441_c((double)(-mop.field_72311_b), (double)(-mop.field_72312_c), (double)(-mop.field_72309_d));
                SelectedPart sPart = PartPlacement.selectPart(player, host, mop.field_72307_f);
                if (sPart != null && sPart.part != null && sPart.part.onShiftActivate(player, mop.field_72307_f)) {
                    if (!world.field_72995_K) return true;
                    NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                    return true;
                }
            }
        }
        if (held == null) return false;
        if (!(held.func_77973_b() instanceof IPartItem)) {
            return false;
        }
        int te_x = x;
        int te_y = y;
        int te_z = z;
        if (host == null && pass == PlaceType.PLACE_ITEM) {
            ItemStack is = AEApi.instance().blocks().blockMultiPart.stack(1);
            ItemBlock ib = (ItemBlock)is.func_77973_b();
            ForgeDirection offset = ForgeDirection.UNKNOWN;
            Block blkID = world.func_147439_a(x, y, z);
            if (blkID != null && !blkID.isReplaceable((IBlockAccess)world, x, y, z)) {
                offset = side;
                if (Platform.isServer()) {
                    side = side.getOpposite();
                }
            }
            if ((tile = world.func_147438_o(te_x = x + offset.offsetX, te_y = y + offset.offsetY, te_z = z + offset.offsetZ)) instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
                host = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getOrCreateHost(tile);
            }
            if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.ImmibisMicroblocks)) {
                host = ((IImmibisMicroblocks)AppEng.instance.getIntegration(IntegrationType.ImmibisMicroblocks)).getOrCreateHost(player, face, tile);
            }
            if (host == null && AEApi.instance().blocks().blockMultiPart.block().func_149742_c(world, te_x, te_y, te_z) && ib.placeBlockAt(is, player, world, te_x, te_y, te_z, side.ordinal(), 0.5f, 0.5f, 0.5f, 0)) {
                if (world.field_72995_K) {
                    player.func_71038_i();
                    NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                    return true;
                }
                tile = world.func_147438_o(te_x, te_y, te_z);
                if (tile instanceof IPartHost) {
                    host = (IPartHost)tile;
                }
                pass = PlaceType.INTERACT_SECOND_PASS;
            } else if (host != null && !host.canAddPart(held, side)) {
                return false;
            }
        }
        if (host == null) {
            return false;
        }
        if (!host.canAddPart(held, side)) {
            PlaceType placeType;
            if (pass != PlaceType.INTERACT_FIRST_PASS) {
                if (pass != PlaceType.PLACE_ITEM) return false;
            }
            te_x = x + side.offsetX;
            te_y = y + side.offsetY;
            te_z = z + side.offsetZ;
            Block blkID = world.func_147439_a(te_x, te_y, te_z);
            tile = world.func_147438_o(te_x, te_y, te_z);
            if (tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
                host = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getOrCreateHost(tile);
            }
            if (blkID != null && !blkID.isReplaceable((IBlockAccess)world, te_x, te_y, te_z)) {
                if (host == null) return false;
            }
            if (side == ForgeDirection.UNKNOWN) return false;
            int n = side.getOpposite().ordinal();
            if (pass == PlaceType.INTERACT_FIRST_PASS) {
                placeType = PlaceType.INTERACT_SECOND_PASS;
                return PartPlacement.place(held, te_x, te_y, te_z, n, player, world, placeType, depth + 1);
            }
            placeType = PlaceType.PLACE_ITEM;
            return PartPlacement.place(held, te_x, te_y, te_z, n, player, world, placeType, depth + 1);
        }
        if (world.field_72995_K) {
            player.func_71038_i();
            NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
            return true;
        }
        Block block2 = world.func_147439_a(x, y, z);
        LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
        MovingObjectPosition mop = block2.func_149731_a(world, x, y, z, dir.a, dir.b);
        if (mop != null) {
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.field_72307_f.func_72441_c((double)(-mop.field_72311_b), (double)(-mop.field_72312_c), (double)(-mop.field_72309_d)));
            if (sp.part != null && !player.func_70093_af() && sp.part.onActivate(player, mop.field_72307_f)) {
                return false;
            }
        }
        if (!Platform.hasPermissions(dc = host.getLocation(), player)) {
            return false;
        }
        ForgeDirection mySide = host.addPart(held, side, player);
        if (mySide == null) return true;
        Block.SoundType ss = AEApi.instance().blocks().blockMultiPart.block().field_149762_H;
        world.func_72908_a(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, ss.func_150496_b(), (ss.func_150497_c() + 1.0f) / 2.0f, ss.func_150494_d() * 0.8f);
        if (player.field_71075_bZ.field_75098_d) return true;
        --held.field_77994_a;
        if (held.field_77994_a != 0) return true;
        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
        return true;
    }

    private static float getEyeOffset(EntityPlayer p) {
        if (p.field_70170_p.field_72995_K) {
            return Platform.getEyeOffset(p);
        }
        return eyeHeight;
    }

    private static SelectedPart selectPart(EntityPlayer player, IPartHost host, Vec3 pos) {
        CommonHelper.proxy.updateRenderMode(player);
        SelectedPart sp = host.selectPart(pos);
        CommonHelper.proxy.updateRenderMode(null);
        return sp;
    }

    public static IFacadePart isFacade(ItemStack held, ForgeDirection side) {
        IBC bc;
        if (held.func_77973_b() instanceof IFacadeItem) {
            return ((IFacadeItem)held.func_77973_b()).createPartFromItemStack(held, side);
        }
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.BC) && (bc = (IBC)AppEng.instance.getIntegration(IntegrationType.BC)).isFacade(held)) {
            return bc.createFacadePart(held, side);
        }
        return null;
    }

    public static enum PlaceType {
        PLACE_ITEM,
        INTERACT_FIRST_PASS,
        INTERACT_SECOND_PASS;

    }
}

