/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEPassThrough;
import appeng.util.prioitylist.DefaultPriorityList;
import appeng.util.prioitylist.IPartitionList;

public class MEInventoryHandler<T extends IAEStack<T>>
implements IMEInventoryHandler<T> {
    final StorageChannel channel;
    protected final IMEMonitor<T> monitor;
    protected final IMEInventoryHandler<T> internal;
    public int myPriority = 0;
    public IncludeExclude myWhitelist = IncludeExclude.WHITELIST;
    public AccessRestriction myAccess = AccessRestriction.READ_WRITE;
    public IPartitionList<T> myPartitionList = new DefaultPriorityList();

    public MEInventoryHandler(IMEInventory<T> i, StorageChannel channel) {
        this.channel = channel;
        this.internal = i instanceof IMEInventoryHandler ? (IMEInventoryHandler<Object>)i : new MEPassThrough<T>(i, channel);
        this.monitor = this.internal instanceof IMEMonitor ? (IMEMonitor)this.internal : null;
    }

    @Override
    public T injectItems(T input, Actionable type, BaseActionSource src) {
        if (!this.canAccept(input)) {
            return input;
        }
        return this.internal.injectItems(input, type, src);
    }

    @Override
    public T extractItems(T request, Actionable type, BaseActionSource src) {
        if (!this.getAccess().hasPermission(AccessRestriction.READ)) {
            return null;
        }
        return this.internal.extractItems(request, type, src);
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        if (!this.getAccess().hasPermission(AccessRestriction.READ)) {
            return out;
        }
        return this.internal.getAvailableItems(out);
    }

    @Override
    public StorageChannel getChannel() {
        return this.internal.getChannel();
    }

    @Override
    public AccessRestriction getAccess() {
        return this.myAccess.restrictPermissions(this.internal.getAccess());
    }

    @Override
    public boolean isPrioritized(T input) {
        if (this.myWhitelist == IncludeExclude.WHITELIST) {
            return this.myPartitionList.isListed(input) || this.internal.isPrioritized(input);
        }
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        if (!this.getAccess().hasPermission(AccessRestriction.WRITE)) {
            return false;
        }
        if (this.myWhitelist == IncludeExclude.BLACKLIST && this.myPartitionList.isListed(input)) {
            return false;
        }
        if (this.myPartitionList.isEmpty() || this.myWhitelist == IncludeExclude.BLACKLIST) {
            return this.internal.canAccept(input);
        }
        return this.myPartitionList.isListed(input) && this.internal.canAccept(input);
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    @Override
    public int getSlot() {
        return this.internal.getSlot();
    }

    public IMEInventory<T> getInternal() {
        return this.internal;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

