/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.CellInventoryHandler;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.HashSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CellInventory
implements ICellInventory {
    static final String ITEM_TYPE_TAG = "it";
    static final String ITEM_COUNT_TAG = "ic";
    static final String ITEM_SLOT = "#";
    static final String ITEM_SLOT_COUNT = "@";
    static final String ITEM_PRE_FORMATTED_COUNT = "PF";
    static final String ITEM_PRE_FORMATTED_SLOT = "PF#";
    static final String ITEM_PRE_FORMATTED_NAME = "PN";
    static final String ITEM_PRE_FORMATTED_FUZZY = "FP";
    protected static String[] ITEM_SLOT_ARR;
    protected static String[] ITEM_SLOT_COUNT_ARR;
    protected final NBTTagCompound tagCompound;
    protected int MAX_ITEM_TYPES = 63;
    protected short storedItems = 0;
    protected int storedItemCount = 0;
    protected IItemList<IAEItemStack> cellItems;
    protected ItemStack i;
    protected IStorageCell CellType;
    protected final ISaveProvider container;
    private static final HashSet<Integer> BLACK_LIST;

    protected CellInventory(NBTTagCompound data, ISaveProvider container) {
        this.tagCompound = data;
        this.container = container;
    }

    protected void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = AEApi.instance().storage().createItemList();
        }
        this.cellItems.resetStatus();
        int types = (int)this.getStoredItemTypes();
        for (int x = 0; x < types; ++x) {
            ItemStack t = ItemStack.func_77949_a((NBTTagCompound)this.tagCompound.func_74775_l(ITEM_SLOT_ARR[x]));
            if (t == null) continue;
            t.field_77994_a = this.tagCompound.func_74762_e(ITEM_SLOT_COUNT_ARR[x]);
            if (t.field_77994_a <= 0) continue;
            this.cellItems.add(AEItemStack.create(t));
        }
    }

    void saveChanges() {
        int itemCount = 0;
        int x = 0;
        for (IAEItemStack v : this.cellItems) {
            itemCount = (int)((long)itemCount + v.getStackSize());
            NBTBase c = this.tagCompound.func_74781_a(ITEM_SLOT_ARR[x]);
            if (c instanceof NBTTagCompound) {
                v.writeToNBT((NBTTagCompound)c);
            } else {
                NBTTagCompound g = new NBTTagCompound();
                v.writeToNBT(g);
                this.tagCompound.func_74782_a(ITEM_SLOT_ARR[x], (NBTBase)g);
            }
            this.tagCompound.func_74768_a(ITEM_SLOT_COUNT_ARR[x], (int)v.getStackSize());
            ++x;
        }
        int oldStoredItems = this.storedItems;
        if (this.cellItems.isEmpty()) {
            this.tagCompound.func_82580_o(ITEM_TYPE_TAG);
        } else {
            this.storedItems = (short)this.cellItems.size();
            this.tagCompound.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        if (itemCount == 0) {
            this.tagCompound.func_82580_o(ITEM_COUNT_TAG);
        } else {
            this.storedItemCount = itemCount;
            this.tagCompound.func_74768_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < this.MAX_ITEM_TYPES) {
            this.tagCompound.func_82580_o(ITEM_SLOT_ARR[x]);
            this.tagCompound.func_82580_o(ITEM_SLOT_COUNT_ARR[x]);
            ++x;
        }
        if (this.container != null) {
            this.container.saveChanges(this);
        }
    }

    protected CellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        if (ITEM_SLOT_ARR == null) {
            ITEM_SLOT_ARR = new String[this.MAX_ITEM_TYPES];
            ITEM_SLOT_COUNT_ARR = new String[this.MAX_ITEM_TYPES];
            for (int x = 0; x < this.MAX_ITEM_TYPES; ++x) {
                CellInventory.ITEM_SLOT_ARR[x] = ITEM_SLOT + x;
                CellInventory.ITEM_SLOT_COUNT_ARR[x] = ITEM_SLOT_COUNT + x;
            }
        }
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.CellType = null;
        this.i = o;
        Item type = this.i.func_77973_b();
        if (type instanceof IStorageCell) {
            this.CellType = (IStorageCell)this.i.func_77973_b();
            this.MAX_ITEM_TYPES = this.CellType.getTotalTypes(this.i);
        }
        if (this.CellType == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (!this.CellType.isStorageCell(this.i)) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (this.MAX_ITEM_TYPES > 63) {
            this.MAX_ITEM_TYPES = 63;
        }
        if (this.MAX_ITEM_TYPES < 1) {
            this.MAX_ITEM_TYPES = 1;
        }
        this.container = container;
        this.tagCompound = Platform.openNbtData(o);
        this.storedItems = this.tagCompound.func_74765_d(ITEM_TYPE_TAG);
        this.storedItemCount = this.tagCompound.func_74762_e(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    IItemList<IAEItemStack> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = AEApi.instance().storage().createItemList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    @Override
    public int getBytesPerType() {
        return this.CellType.BytePerType(this.i);
    }

    @Override
    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public static IMEInventoryHandler getCell(ItemStack o, ISaveProvider container2) {
        try {
            return new CellInventoryHandler(new CellInventory(o, container2));
        }
        catch (AppEngException e) {
            return null;
        }
    }

    private static boolean isStorageCell(ItemStack i) {
        if (i == null) {
            return false;
        }
        try {
            Item type = i.func_77973_b();
            if (type instanceof IStorageCell) {
                return !((IStorageCell)type).storableInStorageCell();
            }
        }
        catch (Throwable err) {
            return true;
        }
        return false;
    }

    public static boolean isCell(ItemStack i) {
        if (i == null) {
            return false;
        }
        Item type = i.func_77973_b();
        if (type instanceof IStorageCell) {
            return ((IStorageCell)type).isStorageCell(i);
        }
        return false;
    }

    @Override
    public long getTotalBytes() {
        return this.CellType.getBytes(this.i);
    }

    @Override
    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    @Override
    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / 8L;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    @Override
    public long getTotalItemTypes() {
        return this.MAX_ITEM_TYPES;
    }

    @Override
    public long getStoredItemTypes() {
        return this.storedItems;
    }

    @Override
    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    private void updateItemCount(long delta) {
        this.storedItemCount = (int)((long)this.storedItemCount + delta);
        this.tagCompound.func_74768_a(ITEM_COUNT_TAG, this.storedItemCount);
    }

    @Override
    public long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    @Override
    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * 8L + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % 8L);
        if (div == 0) {
            return 0;
        }
        return 8 - div;
    }

    public static void addBasicBlackList(int itemID, int Meta) {
        BLACK_LIST.add(Meta << 16 | itemID);
    }

    public static boolean isBlackListed(IAEItemStack input) {
        if (BLACK_LIST.contains(0x7FFF0000 | Item.func_150891_b((Item)input.getItem()))) {
            return true;
        }
        return BLACK_LIST.contains(input.getItemDamage() << 16 | Item.func_150891_b((Item)input.getItem()));
    }

    private boolean isEmpty(IMEInventory meInventory) {
        return meInventory.getAvailableItems(AEApi.instance().storage().createItemList()).isEmpty();
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        int remainingItemCount;
        IMEInventoryHandler meInventory;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (CellInventory.isBlackListed(input) || this.CellType.isBlackListed(this.i, input)) {
            return input;
        }
        ItemStack sharedItemStack = input.getItemStack();
        if (CellInventory.isStorageCell(sharedItemStack) && (meInventory = CellInventory.getCell(sharedItemStack, null)) != null && !this.isEmpty(meInventory)) {
            return input;
        }
        IAEItemStack l = this.getCellItems().findPrecise(input);
        if (l != null) {
            long remainingItemSlots = this.getRemainingItemCount();
            if (remainingItemSlots < 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemSlots) {
                IAEItemStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemSlots);
                    this.updateItemCount(remainingItemSlots);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.updateItemCount(input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = (int)this.getRemainingItemCount() - this.getBytesPerType() * 8) > 0) {
            if (input.getStackSize() > (long)remainingItemCount) {
                ItemStack toReturn = Platform.cloneItemStack(sharedItemStack);
                toReturn.field_77994_a = sharedItemStack.field_77994_a - remainingItemCount;
                if (mode == Actionable.MODULATE) {
                    ItemStack toWrite = Platform.cloneItemStack(sharedItemStack);
                    toWrite.field_77994_a = remainingItemCount;
                    this.cellItems.add(AEItemStack.create(toWrite));
                    this.updateItemCount(toWrite.field_77994_a);
                    this.saveChanges();
                }
                return AEItemStack.create(toReturn);
            }
            if (mode == Actionable.MODULATE) {
                this.updateItemCount(input.getStackSize());
                this.cellItems.add(input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        ItemStack sharedItem = request.getItemStack();
        int size = sharedItem.field_77994_a;
        IAEItemStack Results = null;
        IAEItemStack l = this.getCellItems().findPrecise(request);
        if (l != null) {
            Results = l.copy();
            if (l.getStackSize() <= (long)size) {
                Results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    this.updateItemCount(-l.getStackSize());
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                Results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - (long)size);
                    this.updateItemCount(-size);
                    this.saveChanges();
                }
            }
        }
        return Results;
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        for (IAEItemStack i : this.getCellItems()) {
            out.add(i);
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public double getIdleDrain() {
        return this.CellType.getIdleDrain();
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return this.CellType.getFuzzyMode(this.i);
    }

    @Override
    public IInventory getConfigInventory() {
        return this.CellType.getConfigInventory(this.i);
    }

    @Override
    public IInventory getUpgradesInventory() {
        return this.CellType.getUpgradesInventory(this.i);
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    @Override
    public ItemStack getItemStack() {
        return this.i;
    }

    static {
        BLACK_LIST = new HashSet();
    }
}

