/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.ITickManager;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.parts.p2p.PartP2PTunnelME;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;

public class P2PCache
implements IGridCache {
    private final HashMap<Long, PartP2PTunnel> inputs = new HashMap();
    private final Multimap<Long, PartP2PTunnel> outputs = LinkedHashMultimap.create();
    private final TunnelCollection NullColl = new TunnelCollection(null, null);
    final IGrid myGrid;

    public P2PCache(IGrid g) {
        this.myGrid = g;
    }

    @MENetworkEventSubscribe
    public void bootComplete(MENetworkBootingStatusChange bootStatus) {
        ITickManager tm = (ITickManager)this.myGrid.getCache(ITickManager.class);
        for (PartP2PTunnel me : this.inputs.values()) {
            if (!(me instanceof PartP2PTunnelME)) continue;
            tm.wakeDevice(me.getGridNode());
        }
    }

    @MENetworkEventSubscribe
    public void bootComplete(MENetworkPowerStatusChange power) {
        ITickManager tm = (ITickManager)this.myGrid.getCache(ITickManager.class);
        for (PartP2PTunnel me : this.inputs.values()) {
            if (!(me instanceof PartP2PTunnelME)) continue;
            tm.wakeDevice(me.getGridNode());
        }
    }

    @Override
    public void onUpdateTick() {
    }

    public void updateFreq(PartP2PTunnel t, long NewFreq) {
        if (this.outputs.containsValue((Object)t)) {
            this.outputs.remove((Object)t.freq, (Object)t);
        }
        if (this.inputs.containsValue(t)) {
            this.inputs.remove(t.freq);
        }
        t.freq = NewFreq;
        if (t.output) {
            this.outputs.put((Object)t.freq, (Object)t);
        } else {
            this.inputs.put(t.freq, t);
        }
        this.updateTunnel(t.freq, t.output, true);
        this.updateTunnel(t.freq, !t.output, true);
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (machine instanceof PartP2PTunnel) {
            if (machine instanceof PartP2PTunnelME && !node.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                return;
            }
            PartP2PTunnel t = (PartP2PTunnel)machine;
            if (t.output) {
                this.outputs.put((Object)t.freq, (Object)t);
            } else {
                this.inputs.put(t.freq, t);
            }
            this.updateTunnel(t.freq, !t.output, false);
        }
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        if (machine instanceof PartP2PTunnel) {
            if (machine instanceof PartP2PTunnelME && !node.hasFlag(GridFlags.REQUIRE_CHANNEL)) {
                return;
            }
            PartP2PTunnel t = (PartP2PTunnel)machine;
            if (t.output) {
                this.outputs.remove((Object)t.freq, (Object)t);
            } else {
                this.inputs.remove(t.freq);
            }
            this.updateTunnel(t.freq, !t.output, false);
        }
    }

    private void updateTunnel(long freq, boolean updateOutputs, boolean configChange) {
        for (PartP2PTunnel p : this.outputs.get((Object)freq)) {
            if (configChange) {
                p.onTunnelConfigChange();
            }
            p.onTunnelNetworkChange();
        }
        PartP2PTunnel in = this.inputs.get(freq);
        if (in != null) {
            if (configChange) {
                in.onTunnelConfigChange();
            }
            in.onTunnelNetworkChange();
        }
    }

    public TunnelCollection<PartP2PTunnel> getOutputs(long freq, Class<? extends PartP2PTunnel> c) {
        PartP2PTunnel in = this.inputs.get(freq);
        if (in == null) {
            return this.NullColl;
        }
        TunnelCollection<PartP2PTunnel> out = this.inputs.get(freq).getCollection(this.outputs.get((Object)freq), c);
        if (out == null) {
            return this.NullColl;
        }
        return out;
    }

    public PartP2PTunnel getInput(long freq) {
        return this.inputs.get(freq);
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }
}

