/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.recipes.ResolverResult;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.EntityGrowingCrystal;
import appeng.entity.EntityIds;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemCrystalSeed
extends AEBaseItem
implements IGrowableCrystal {
    public static final int LEVEL_OFFSET = 200;
    public static final int SINGLE_OFFSET = 600;
    public static final int Certus = 0;
    public static final int Nether = 600;
    public static final int Fluix = 1200;
    public static final int END = 1800;
    final IIcon[] certus = new IIcon[3];
    final IIcon[] fluix = new IIcon[3];
    final IIcon[] nether = new IIcon[3];

    private int getProgress(ItemStack is) {
        if (is.func_77942_o()) {
            return is.func_77978_p().func_74762_e("progress");
        }
        NBTTagCompound comp = Platform.openNbtData(is);
        int progress = is.func_77960_j();
        comp.func_74768_a("progress", progress);
        is.func_77964_b(is.func_77960_j() / 600 * 600);
        return progress;
    }

    private void setProgress(ItemStack is, int newDamage) {
        NBTTagCompound comp = Platform.openNbtData(is);
        comp.func_74768_a("progress", newDamage);
        is.func_77964_b(is.func_77960_j() / 200 * 200);
    }

    public ItemCrystalSeed() {
        super(ItemCrystalSeed.class);
        this.func_77627_a(true);
        this.setFeature(EnumSet.of(AEFeature.Core));
        EntityRegistry.registerModEntity(EntityGrowingCrystal.class, (String)EntityGrowingCrystal.class.getSimpleName(), (int)EntityIds.get(EntityGrowingCrystal.class), (Object)AppEng.instance, (int)16, (int)4, (boolean)true);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public String func_77667_c(ItemStack is) {
        int damage = this.getProgress(is);
        if (damage < 600) {
            return this.func_77658_a() + ".Certus";
        }
        if (damage < 1200) {
            return this.func_77658_a() + ".Nether";
        }
        if (damage < 1800) {
            return this.func_77658_a() + ".Fluix";
        }
        return this.func_77658_a();
    }

    @Override
    public ItemStack triggerGrowth(ItemStack is) {
        int newDamage = this.getProgress(is) + 1;
        if (newDamage == 600) {
            return AEApi.instance().materials().materialPurifiedCertusQuartzCrystal.stack(is.field_77994_a);
        }
        if (newDamage == 1200) {
            return AEApi.instance().materials().materialPurifiedNetherQuartzCrystal.stack(is.field_77994_a);
        }
        if (newDamage == 1800) {
            return AEApi.instance().materials().materialPurifiedFluixCrystal.stack(is.field_77994_a);
        }
        if (newDamage > 1800) {
            return null;
        }
        this.setProgress(is, newDamage);
        return is;
    }

    public boolean func_77645_m() {
        return false;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayAdditionalInformation) {
        lines.add(ButtonToolTips.DoesntDespawn.getLocal());
        int progress = this.getProgress(stack) % 600;
        lines.add(Math.floor((float)progress / 6.0f) + "%");
        super.addCheckedInformation(stack, player, lines, displayAdditionalInformation);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1800;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        IIcon[] list = null;
        int damage = this.getProgress(stack);
        if (damage < 600) {
            list = this.certus;
        } else if (damage < 1200) {
            damage -= 600;
            list = this.nether;
        } else if (damage < 1800) {
            damage -= 1200;
            list = this.fluix;
        }
        if (list == null) {
            return Items.field_151045_i.func_77617_a(0);
        }
        if (damage < 200) {
            return list[0];
        }
        if (damage < 400) {
            return list[1];
        }
        return list[2];
    }

    @Override
    public float getMultiplier(Block blk, Material mat) {
        return 0.5f;
    }

    public void func_94581_a(IIconRegister ir) {
        String preFix = "appliedenergistics2:ItemCrystalSeed.";
        this.certus[0] = ir.func_94245_a(preFix + "Certus");
        this.certus[1] = ir.func_94245_a(preFix + "Certus2");
        this.certus[2] = ir.func_94245_a(preFix + "Certus3");
        this.nether[0] = ir.func_94245_a(preFix + "Nether");
        this.nether[1] = ir.func_94245_a(preFix + "Nether2");
        this.nether[2] = ir.func_94245_a(preFix + "Nether3");
        this.fluix[0] = ir.func_94245_a(preFix + "Fluix");
        this.fluix[1] = ir.func_94245_a(preFix + "Fluix2");
        this.fluix[2] = ir.func_94245_a(preFix + "Fluix3");
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityGrowingCrystal egc = new EntityGrowingCrystal(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        egc.field_70159_w = location.field_70159_w;
        egc.field_70181_x = location.field_70181_x;
        egc.field_70179_y = location.field_70179_y;
        if (location instanceof EntityItem) {
            egc.field_145804_b = ((EntityItem)location).field_145804_b;
        }
        return egc;
    }

    public void func_150895_a(Item i, CreativeTabs t, List l) {
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 0)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 600)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1200)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 200)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 800)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1400)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 400)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1000)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1600)));
    }

    private static ItemStack newStyle(ItemStack itemStack) {
        ((ItemCrystalSeed)itemStack.func_77973_b()).getProgress(itemStack);
        return itemStack;
    }

    public static ResolverResult getResolver(int certus2) {
        ItemStack is = AEApi.instance().items().itemCrystalSeed.stack(1);
        is.func_77964_b(certus2);
        is = ItemCrystalSeed.newStyle(is);
        return new ResolverResult("ItemCrystalSeed", is.func_77960_j(), is.func_77978_p());
    }
}

